/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.ns;

import java.io.IOException;
import java.lang.reflect.Executable;
import java.nio.ByteOrder;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.driver.ClioSupport;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Log;
import oracle.jdbc.logging.annotations.Supports;
import oracle.jdbc.logging.runtime.TraceControllerImpl;
import oracle.net.ns.NIOPacket;
import oracle.net.ns.SQLnetDef;
import oracle.net.ns.SessionAtts;

@DefaultLogger(value="oracle.net.ns")
@Supports(value={Feature.NET})
public final class NIODataDescriptorPacket
extends NIOPacket
implements SQLnetDef {
    int totalDataLength;
    int descriptorFLaG;
    int[] sdd;
    boolean useLongDescriptor;
    private static final byte[] STANDARD_SDD_MAX_DD_HEADER_SHORT_SDU;
    private static final byte[] STANDARD_SDD_MAX_DD_HEADER_LARGE_SDU;
    private static final byte[] STANDARD_SDD_MAX_DD_PAYLOAD;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;

    NIODataDescriptorPacket(SessionAtts sAtts) {
        super(sAtts);
        boolean bl = (0x20000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$2, Level.FINEST, NIODataDescriptorPacket.class, $$$methodRef$$$2, null, sAtts);
            }
            this.sdd = new int[26];
            this.useLongDescriptor = false;
            this.header.type = 15;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$2, Level.FINEST, NIODataDescriptorPacket.class, $$$methodRef$$$2, null);
                ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, NIODataDescriptorPacket.class, $$$methodRef$$$2, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, NIODataDescriptorPacket.class, $$$methodRef$$$2, null, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    void readPayloadBuffer() throws IOException {
        boolean bl = (0x20000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$0, Level.FINEST, NIODataDescriptorPacket.class, $$$methodRef$$$0, this, new Object[0]);
            }
            ByteOrder originalOrder = this.session.readBuffer.order();
            this.session.readBuffer.order(ByteOrder.BIG_ENDIAN);
            this.descriptorFLaG = this.session.payloadBufferForRead.getInt();
            this.useLongDescriptor = (this.descriptorFLaG & 2) == 0;
            this.totalDataLength = this.session.payloadBufferForRead.getInt();
            if (bl) {
                this.debug($$$loggerRef$$$0, Level.FINEST, $$$methodRef$$$0, "descriptorFlag=" + this.descriptorFLaG + ", useLongDescriptor=" + this.useLongDescriptor + ", totalDataLength=" + this.totalDataLength + ", sessionTraceId=" + this.session.traceId);
            }
            this.session.readBuffer.order(originalOrder);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$0, Level.FINEST, NIODataDescriptorPacket.class, $$$methodRef$$$0, this);
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, NIODataDescriptorPacket.class, $$$methodRef$$$0, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, NIODataDescriptorPacket.class, $$$methodRef$$$0, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    final void writeToSocketChannel(int n2, boolean bl) throws IOException {
        boolean bl2 = (0x20000000L & TraceControllerImpl.feature) != 0L;
        try {
            void marker;
            void totalLength;
            if (bl2) {
                ClioSupport.entering($$$loggerRef$$$1, Level.FINEST, NIODataDescriptorPacket.class, $$$methodRef$$$1, this, n2, bl);
            }
            if (totalLength == 1703910 && marker == false) {
                this.session.writeBuffer.clear();
                if (this.session.isLargeSDU) {
                    this.session.writeBuffer.put(STANDARD_SDD_MAX_DD_HEADER_LARGE_SDU, 0, STANDARD_SDD_MAX_DD_HEADER_LARGE_SDU.length);
                } else {
                    this.session.writeBuffer.put(STANDARD_SDD_MAX_DD_HEADER_SHORT_SDU, 0, STANDARD_SDD_MAX_DD_HEADER_SHORT_SDU.length);
                }
                this.session.writeBuffer.put(STANDARD_SDD_MAX_DD_PAYLOAD, 0, STANDARD_SDD_MAX_DD_PAYLOAD.length);
                this.session.writeBuffer.flip();
                if (bl2) {
                    this.debug($$$loggerRef$$$1, Level.FINEST, $$$methodRef$$$1, "(1):totalLength=" + (int)totalLength + ", marker=" + (boolean)marker + "\n" + this.dumpBytes(this.session.writeBuffer, 0, (int)totalLength));
                }
                while (this.session.writeBuffer.hasRemaining()) {
                    this.session.socketChannel.write(this.session.writeBuffer);
                }
            } else {
                int i2;
                this.useLongDescriptor = false;
                this.descriptorFLaG = 2;
                if (marker != false) {
                    this.descriptorFLaG |= 1;
                }
                int nbOfDD = 0;
                void remainingBytes = totalLength;
                while (remainingBytes > 0) {
                    this.sdd[nbOfDD] = remainingBytes > 65535 ? 65535 : remainingBytes;
                    remainingBytes -= this.sdd[nbOfDD];
                    ++nbOfDD;
                }
                this.session.payloadBufferForWrite.clear();
                this.session.payloadBufferForWrite.putInt(this.descriptorFLaG);
                this.session.payloadBufferForWrite.putInt((int)totalLength);
                this.session.payloadBufferForWrite.putInt(nbOfDD);
                for (i2 = 0; i2 < nbOfDD; ++i2) {
                    this.session.payloadBufferForWrite.putShort((short)this.sdd[i2]);
                }
                for (i2 = nbOfDD; i2 < 26; ++i2) {
                    this.session.payloadBufferForWrite.putShort((short)0);
                }
                this.writeToSocketChannel();
            }
            if (bl2) {
                ClioSupport.returning($$$loggerRef$$$1, Level.FINEST, NIODataDescriptorPacket.class, $$$methodRef$$$1, this);
                ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, NIODataDescriptorPacket.class, $$$methodRef$$$1, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl2) {
                ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, NIODataDescriptorPacket.class, $$$methodRef$$$1, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    @Log
    protected void debug(Logger logger, Level level, Executable method, String msg) {
        ClioSupport.log(logger, level, this.getClass(), method, msg);
    }

    static {
        try {
            $$$methodRef$$$2 = NIODataDescriptorPacket.class.getDeclaredConstructor(SessionAtts.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net.ns");
        try {
            $$$methodRef$$$1 = NIODataDescriptorPacket.class.getDeclaredMethod("writeToSocketChannel", Integer.TYPE, Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net.ns");
        try {
            $$$methodRef$$$0 = NIODataDescriptorPacket.class.getDeclaredMethod("readPayloadBuffer", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net.ns");
        STANDARD_SDD_MAX_DD_HEADER_SHORT_SDU = new byte[]{0, 72, 0, 0, 15, 0, 0, 0};
        STANDARD_SDD_MAX_DD_HEADER_LARGE_SDU = new byte[]{0, 0, 0, 72, 15, 0, 0, 0};
        STANDARD_SDD_MAX_DD_PAYLOAD = new byte[]{0, 0, 0, 2, 0, 25, -1, -26, 0, 0, 0, 26, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1};
    }
}

