/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.resolver;

import java.lang.reflect.Executable;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.logging.Logger;
import oracle.net.jdbc.nl.InvalidSyntaxException;
import oracle.net.jdbc.nl.NLException;
import oracle.net.jdbc.nl.NVFactory;
import oracle.net.jdbc.nl.NVPair;
import oracle.net.ns.NetException;
import oracle.net.resolver.HostnameNamingAdapter;
import oracle.net.resolver.NamingAdapterInterface;
import oracle.net.resolver.TNSNamesNamingAdapter;

public class NameResolver {
    private String tnsAdmin;
    private String[] readPath;
    private Hashtable adapterHash;
    String osuser;
    String programName;
    private static final boolean DEBUG = false;
    private static final String[] DEFAULT_SEARCH_PATH;
    private static final String TNS_ADMIN_PROPERTY = "oracle.net.tns_admin";
    private static final String READ_PATH_PROPERTY = "oracle.net.names.directory_path";
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;

    private NameResolver() {
    }

    protected NameResolver(String tnsValue, String _osuser, String _programName) throws NetException {
        this.tnsAdmin = tnsValue;
        this.bootNameResolver();
        this.osuser = _osuser;
        this.programName = _programName;
    }

    public String resolveName(String connId) throws NetException {
        String trcHdr = "NameResolver.resolveName: ";
        if (connId == null) {
            throw new NetException(120);
        }
        String tempConnId = connId.trim();
        if (tempConnId.length() == 0) {
            throw new NetException(120);
        }
        String connStr = null;
        if (this.tnsAdmin == null) {
            HostnameNamingAdapter h2 = new HostnameNamingAdapter(this.osuser, this.programName);
            connStr = h2.resolve(tempConnId);
            return connStr;
        }
        NamingAdapterInterface adapter = null;
        for (int adapNum = 0; connStr == null && adapNum < this.readPath.length; ++adapNum) {
            adapter = (NamingAdapterInterface)this.adapterHash.get(this.readPath[adapNum]);
            try {
                connStr = adapter.resolve(tempConnId);
                continue;
            }
            catch (NetException netException) {
                // empty catch block
            }
        }
        if (connStr == null) {
            throw new NetException(122, "\"" + connId + "\"");
        }
        return connStr;
    }

    private void addAdapters() {
        if (this.adapterHash == null) {
            this.adapterHash = new Hashtable();
        }
        this.adapterHash.put("TNSNAMES", new TNSNamesNamingAdapter(this.tnsAdmin));
        this.adapterHash.put("HOSTNAME", new HostnameNamingAdapter(this.osuser, this.programName));
    }

    private void bootNameResolver() throws NetException {
        if (this.tnsAdmin != null) {
            this.setReadPath();
            this.addAdapters();
        }
    }

    private boolean checkForValidAdapter(String adaptername) {
        int totAdapters = DEFAULT_SEARCH_PATH.length;
        for (int iterCnt = 0; iterCnt < totAdapters; ++iterCnt) {
            if (!DEFAULT_SEARCH_PATH[iterCnt].equalsIgnoreCase(adaptername)) continue;
            return true;
        }
        return false;
    }

    private void setDefaultPath() {
        this.readPath = DEFAULT_SEARCH_PATH;
    }

    private void setReadPath() throws NetException {
        String trcHdr = "NameResolver.setReadPath: ";
        int iterCnt = 0;
        String[] adapterList = this.getUserReadPath();
        if (adapterList == null) {
            this.setDefaultPath();
            return;
        }
        ArrayList<String> tempList = new ArrayList<String>();
        for (iterCnt = 0; iterCnt < adapterList.length; ++iterCnt) {
            if (!this.checkForValidAdapter(adapterList[iterCnt])) continue;
            String tempStr = adapterList[iterCnt];
            if (tempList.contains(tempStr = tempStr.toUpperCase())) continue;
            tempList.add(adapterList[iterCnt].toUpperCase());
        }
        int validCnt = tempList.size();
        if (validCnt == 0) {
            throw new NetException(121, " The Read path did not contain any valid adapters.");
        }
        this.readPath = new String[validCnt];
        tempList.toArray(this.readPath);
    }

    private String[] getUserReadPath() throws NetException {
        String trcHdr = "NameResolver.getUserReadPath: ";
        String[] resultStr = null;
        String nameStr = System.getProperty(READ_PATH_PROPERTY);
        if (nameStr == null) {
            return null;
        }
        if ((nameStr = nameStr.trim()).length() == 0) {
            return null;
        }
        StringBuffer buffStr = new StringBuffer(nameStr);
        if (buffStr.charAt(0) == '(') {
            buffStr.insert(0, "(path=").append(')');
        } else {
            buffStr.insert(0, "(path=(").append("))");
        }
        String nvStr = buffStr.toString();
        NVFactory nvf = new NVFactory();
        NVPair nvp = null;
        try {
            nvp = nvf.createNVPair(nvStr);
            if (nvp.getRHSType() != NVPair.RHS_LIST || nvp.getListType() != NVPair.LIST_COMMASEP) {
                throw new NetException(121, " Read path specified is " + nameStr);
            }
            int entries = nvp.getListSize();
            String[] path = new String[entries];
            for (int iterCnt = 0; iterCnt < entries; ++iterCnt) {
                path[iterCnt] = nvp.getListElement(iterCnt).getName();
            }
            resultStr = path;
        }
        catch (InvalidSyntaxException ie) {
            throw new NetException(121, " Read path specified is " + nameStr);
        }
        catch (NLException nle) {
            throw new NetException(121, " Read path specified is " + nvStr);
        }
        return resultStr;
    }

    static {
        try {
            $$$methodRef$$$8 = NameResolver.class.getDeclaredConstructor(String.class, String.class, String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$7 = NameResolver.class.getDeclaredConstructor(new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$6 = NameResolver.class.getDeclaredMethod("getUserReadPath", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$5 = NameResolver.class.getDeclaredMethod("setReadPath", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$4 = NameResolver.class.getDeclaredMethod("setDefaultPath", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$3 = NameResolver.class.getDeclaredMethod("checkForValidAdapter", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$2 = NameResolver.class.getDeclaredMethod("bootNameResolver", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$1 = NameResolver.class.getDeclaredMethod("addAdapters", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = NameResolver.class.getDeclaredMethod("resolveName", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        DEFAULT_SEARCH_PATH = new String[]{"TNSNAMES", "HOSTNAME"};
    }
}

