/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.docker.compose;

import com.google.common.base.Throwables;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.palantir.docker.compose.CustomImmutablesStyle;
import com.palantir.docker.compose.EventEmitter;
import com.palantir.docker.compose.ImmutableDockerComposeManager;
import com.palantir.docker.compose.configuration.DockerComposeFiles;
import com.palantir.docker.compose.configuration.ProjectName;
import com.palantir.docker.compose.configuration.ShutdownStrategy;
import com.palantir.docker.compose.connection.Cluster;
import com.palantir.docker.compose.connection.Container;
import com.palantir.docker.compose.connection.ContainerCache;
import com.palantir.docker.compose.connection.DockerMachine;
import com.palantir.docker.compose.connection.DockerPort;
import com.palantir.docker.compose.connection.ImmutableCluster;
import com.palantir.docker.compose.connection.waiting.ClusterHealthCheck;
import com.palantir.docker.compose.connection.waiting.ClusterWait;
import com.palantir.docker.compose.connection.waiting.HealthCheck;
import com.palantir.docker.compose.events.EventConsumer;
import com.palantir.docker.compose.execution.ConflictingContainerRemovingDockerCompose;
import com.palantir.docker.compose.execution.DefaultDockerCompose;
import com.palantir.docker.compose.execution.Docker;
import com.palantir.docker.compose.execution.DockerCompose;
import com.palantir.docker.compose.execution.DockerComposeExecArgument;
import com.palantir.docker.compose.execution.DockerComposeExecOption;
import com.palantir.docker.compose.execution.DockerComposeExecutable;
import com.palantir.docker.compose.execution.DockerComposeRunArgument;
import com.palantir.docker.compose.execution.DockerComposeRunOption;
import com.palantir.docker.compose.execution.DockerExecutable;
import com.palantir.docker.compose.execution.RetryingDockerCompose;
import com.palantir.docker.compose.logging.DoNothingLogCollector;
import com.palantir.docker.compose.logging.FileLogCollector;
import com.palantir.docker.compose.logging.LogCollector;
import com.palantir.docker.compose.report.TestDescription;
import com.palantir.docker.compose.reporting.RunRecorder;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.immutables.value.Value;
import org.joda.time.Duration;
import org.joda.time.ReadableDuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Value.Immutable
@CustomImmutablesStyle
public abstract class DockerComposeManager {
    private static final Logger log = LoggerFactory.getLogger(DockerComposeManager.class);
    public static final Duration DEFAULT_TIMEOUT = Duration.standardMinutes((long)2L);
    public static final int DEFAULT_RETRY_ATTEMPTS = 2;
    private final RunRecorder runRecorder = RunRecorder.defaults();

    public DockerPort hostNetworkedPort(int port) {
        return new DockerPort(this.machine().getIp(), port, port);
    }

    public abstract DockerComposeFiles files();

    protected abstract List<ClusterWait> clusterWaits();

    protected abstract List<EventConsumer> eventConsumers();

    @Value.Default
    public DockerMachine machine() {
        return DockerMachine.localMachine().build();
    }

    @Value.Default
    public ProjectName projectName() {
        return ProjectName.random();
    }

    @Value.Default
    public DockerComposeExecutable dockerComposeExecutable() {
        return DockerComposeExecutable.builder().dockerComposeFiles(this.files()).dockerConfiguration(this.machine()).projectName(this.projectName()).build();
    }

    @Value.Default
    public DockerExecutable dockerExecutable() {
        return DockerExecutable.builder().dockerConfiguration(this.machine()).build();
    }

    @Value.Default
    public Docker docker() {
        return new Docker(this.dockerExecutable());
    }

    @Value.Default
    public ShutdownStrategy shutdownStrategy() {
        return ShutdownStrategy.KILL_DOWN;
    }

    @Value.Default
    public DockerCompose dockerCompose() {
        DefaultDockerCompose dockerCompose = new DefaultDockerCompose(this.dockerComposeExecutable(), this.machine());
        return new RetryingDockerCompose(this.retryAttempts(), (DockerCompose)dockerCompose);
    }

    @Value.Default
    public Cluster containers() {
        return ImmutableCluster.builder().ip(this.machine().getIp()).containerCache(new ContainerCache(this.docker(), this.dockerCompose())).build();
    }

    @Value.Default
    protected int retryAttempts() {
        return 2;
    }

    @Value.Default
    protected boolean removeConflictingContainersOnStartup() {
        return true;
    }

    @Value.Default
    protected boolean pullOnStartup() {
        return false;
    }

    @Value.Default
    protected ReadableDuration nativeServiceHealthCheckTimeout() {
        return DEFAULT_TIMEOUT;
    }

    @Value.Default
    protected LogCollector logCollector() {
        return new DoNothingLogCollector();
    }

    @Value.Derived
    protected EventEmitter emitEventsFor() {
        List<EventConsumer> eventConsumers = Stream.concat(Stream.of(this.runRecorder), this.eventConsumers().stream()).collect(Collectors.toList());
        return new EventEmitter(eventConsumers);
    }

    protected void setDescription(TestDescription testDescription) {
        this.runRecorder.setDescription(testDescription);
    }

    public void before() throws IOException, InterruptedException {
        log.debug("Starting docker-compose cluster");
        this.runRecorder.before(() -> this.dockerCompose().config());
        this.pullBuildAndUp();
        this.emitEventsFor().waitingForServices(this::waitForServices);
    }

    private void pullBuildAndUp() throws IOException, InterruptedException {
        if (this.pullOnStartup()) {
            this.emitEventsFor().pull(this.dockerCompose()::pull);
        }
        this.emitEventsFor().build(this.dockerCompose()::build);
        DockerCompose upDockerCompose = this.dockerCompose();
        if (this.removeConflictingContainersOnStartup()) {
            upDockerCompose = new ConflictingContainerRemovingDockerCompose(upDockerCompose, this.docker());
        }
        this.emitEventsFor().up(upDockerCompose::up);
    }

    private void waitForServices() throws InterruptedException {
        log.debug("Waiting for services");
        EventEmitter.InterruptableClusterWait nativeHealthCheckClusterWait = this.emitEventsFor().nativeClusterWait(new ClusterWait(ClusterHealthCheck.nativeHealthChecks(), this.nativeServiceHealthCheckTimeout()));
        List<EventEmitter.InterruptableClusterWait> allClusterWaits = Stream.concat(Stream.of(nativeHealthCheckClusterWait), this.clusterWaits().stream().map(this.emitEventsFor()::userClusterWait)).collect(Collectors.toList());
        this.waitForAllClusterWaits(allClusterWaits);
        log.debug("docker-compose cluster started");
    }

    private void waitForAllClusterWaits(List<EventEmitter.InterruptableClusterWait> allClusterWaits) throws InterruptedException {
        ListeningExecutorService executorService = MoreExecutors.listeningDecorator((ExecutorService)Executors.newFixedThreadPool(allClusterWaits.size(), new ThreadFactoryBuilder().setNameFormat("dcr-wait-%d").build()));
        try {
            ListenableFuture listListenableFuture = Futures.allAsList((Iterable)allClusterWaits.stream().map(clusterWait -> executorService.submit(() -> {
                try {
                    clusterWait.waitForCluster(this.containers());
                }
                catch (InterruptedException e) {
                    if (executorService.isShutdown()) {
                        return;
                    }
                    Throwables.propagate((Throwable)e);
                }
            })).collect(Collectors.toList()));
            listListenableFuture.get();
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof RuntimeException) {
                throw (RuntimeException)e.getCause();
            }
            throw new IllegalStateException("A cluster wait errored out: ", e);
        }
        finally {
            MoreExecutors.shutdownAndAwaitTermination((ExecutorService)executorService, (long)0L, (TimeUnit)TimeUnit.SECONDS);
        }
    }

    public void after() {
        try {
            this.emitEventsFor().shutdownStop(() -> this.shutdownStrategy().stop(this.dockerCompose()));
            this.emitEventsFor().logCollection(() -> this.logCollector().collectLogs(this.dockerCompose()));
            this.emitEventsFor().shutdown(() -> this.shutdownStrategy().shutdown(this.dockerCompose(), this.docker()));
        }
        catch (IOException | InterruptedException e) {
            throw new RuntimeException("Error cleaning up docker compose cluster", e);
        }
        finally {
            this.runRecorder.after();
        }
    }

    public String exec(DockerComposeExecOption options, String containerName, DockerComposeExecArgument arguments) throws IOException, InterruptedException {
        return this.dockerCompose().exec(options, containerName, arguments);
    }

    public String run(DockerComposeRunOption options, String containerName, DockerComposeRunArgument arguments) throws IOException, InterruptedException {
        return this.dockerCompose().run(options, containerName, arguments);
    }

    public static class Builder
    extends ImmutableDockerComposeManager.Builder
    implements BuilderExtensions<Builder> {
        @Override
        public DockerComposeManager build() {
            return super.build();
        }
    }

    public static interface BuilderExtensions<TSelf extends BuilderExtensions<TSelf>> {
        public TSelf files(DockerComposeFiles var1);

        public TSelf logCollector(LogCollector var1);

        public TSelf shutdownStrategy(ShutdownStrategy var1);

        public TSelf addClusterWait(ClusterWait var1);

        public TSelf addAllClusterWaits(Iterable<? extends ClusterWait> var1);

        default public TSelf file(String dockerComposeYmlFile) {
            return this.files(DockerComposeFiles.from(dockerComposeYmlFile));
        }

        default public TSelf saveLogsTo(String path) {
            return this.logCollector(FileLogCollector.fromPath(path));
        }

        @Deprecated
        default public TSelf skipShutdown(boolean skipShutdown) {
            if (skipShutdown) {
                return this.shutdownStrategy(ShutdownStrategy.SKIP);
            }
            return (TSelf)this;
        }

        default public TSelf waitingForService(String serviceName, HealthCheck<Container> healthCheck) {
            return this.waitingForService(serviceName, healthCheck, (ReadableDuration)DEFAULT_TIMEOUT);
        }

        default public TSelf waitingForService(String serviceName, HealthCheck<Container> healthCheck, ReadableDuration timeout) {
            ClusterHealthCheck clusterHealthCheck = ClusterHealthCheck.serviceHealthCheck(serviceName, healthCheck);
            return this.addClusterWait(new ClusterWait(clusterHealthCheck, timeout));
        }

        default public TSelf waitingForServices(List<String> services, HealthCheck<List<Container>> healthCheck) {
            return this.waitingForServices(services, healthCheck, (ReadableDuration)DEFAULT_TIMEOUT);
        }

        default public TSelf waitingForServices(List<String> services, HealthCheck<List<Container>> healthCheck, ReadableDuration timeout) {
            ClusterHealthCheck clusterHealthCheck = ClusterHealthCheck.serviceHealthCheck(services, healthCheck);
            return this.addClusterWait(new ClusterWait(clusterHealthCheck, timeout));
        }

        default public TSelf waitingForHostNetworkedPort(int port, HealthCheck<DockerPort> healthCheck) {
            return this.waitingForHostNetworkedPort(port, healthCheck, (ReadableDuration)DEFAULT_TIMEOUT);
        }

        default public TSelf waitingForHostNetworkedPort(int port, HealthCheck<DockerPort> healthCheck, ReadableDuration timeout) {
            ClusterHealthCheck clusterHealthCheck = ClusterHealthCheck.transformingHealthCheck(cluster -> new DockerPort(cluster.ip(), port, port), healthCheck);
            return this.addClusterWait(new ClusterWait(clusterHealthCheck, timeout));
        }

        default public TSelf clusterWaits(Iterable<? extends ClusterWait> elements) {
            return this.addAllClusterWaits(elements);
        }
    }
}

