/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.docker.compose;

import com.google.common.base.Throwables;
import com.palantir.docker.compose.RecordingClusterWait;
import com.palantir.docker.compose.connection.Cluster;
import com.palantir.docker.compose.connection.waiting.ClusterWait;
import com.palantir.docker.compose.connection.waiting.Exceptions;
import com.palantir.docker.compose.events.BuildEvent;
import com.palantir.docker.compose.events.ClusterWaitEvent;
import com.palantir.docker.compose.events.ClusterWaitType;
import com.palantir.docker.compose.events.Event;
import com.palantir.docker.compose.events.EventConsumer;
import com.palantir.docker.compose.events.LogCollectionEvent;
import com.palantir.docker.compose.events.PullEvent;
import com.palantir.docker.compose.events.ShutdownEvent;
import com.palantir.docker.compose.events.ShutdownStopEvent;
import com.palantir.docker.compose.events.Task;
import com.palantir.docker.compose.events.UpEvent;
import com.palantir.docker.compose.events.WaitForServicesEvent;
import java.io.IOException;
import java.time.Clock;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class EventEmitter {
    private static final Logger log = LoggerFactory.getLogger(EventEmitter.class);
    private final Clock clock;
    private final List<EventConsumer> eventConsumers;

    EventEmitter(List<EventConsumer> eventConsumers) {
        this(Clock.systemUTC(), eventConsumers);
    }

    EventEmitter(Clock clock, List<EventConsumer> eventConsumers) {
        this.clock = clock;
        this.eventConsumers = eventConsumers;
    }

    public void pull(CheckedRunnable runnable) throws IOException, InterruptedException {
        this.emitTask(runnable, task -> Event.pull((PullEvent)PullEvent.builder().task(task).build()));
    }

    public void build(CheckedRunnable runnable) throws IOException, InterruptedException {
        this.emitTask(runnable, task -> Event.build((BuildEvent)BuildEvent.builder().task(task).build()));
    }

    public void up(CheckedRunnable runnable) throws IOException, InterruptedException {
        this.emitTask(runnable, task -> Event.up((UpEvent)UpEvent.builder().task(task).build()));
    }

    public void waitingForServices(CheckedRunnable runnable) throws IOException, InterruptedException {
        this.emitTask(runnable, task -> Event.waitForServices((WaitForServicesEvent)WaitForServicesEvent.builder().task(task).build()));
    }

    public void shutdownStop(CheckedRunnable runnable) throws IOException, InterruptedException {
        this.emitTask(runnable, task -> Event.shutdownStop((ShutdownStopEvent)ShutdownStopEvent.builder().task(task).build()));
    }

    public void logCollection(CheckedRunnable runnable) throws IOException, InterruptedException {
        this.emitTask(runnable, task -> Event.logCollection((LogCollectionEvent)LogCollectionEvent.builder().task(task).build()));
    }

    public void shutdown(CheckedRunnable runnable) throws IOException, InterruptedException {
        this.emitTask(runnable, task -> Event.shutdown((ShutdownEvent)ShutdownEvent.builder().task(task).build()));
    }

    public InterruptableClusterWait userClusterWait(ClusterWait clusterWait) {
        return this.clusterWait(ClusterWaitType.USER, clusterWait);
    }

    public InterruptableClusterWait nativeClusterWait(ClusterWait clusterWait) {
        return this.clusterWait(ClusterWaitType.NATIVE, clusterWait);
    }

    private InterruptableClusterWait clusterWait(ClusterWaitType clusterWaitType, ClusterWait clusterWait) {
        RecordingClusterWait recordingClusterWait = new RecordingClusterWait(clusterWait, clusterWaitType);
        return cluster -> this.emitNotThrowing(() -> recordingClusterWait.waitForCluster(cluster), task -> Event.clusterWait((ClusterWaitEvent)ClusterWaitEvent.builder().task(task).serviceNames(recordingClusterWait.recordedServiceNames()).type(clusterWaitType).build()));
    }

    private void emitNotThrowing(CheckedRunnable runnable, Function<Task, Event> eventFunction) throws InterruptedException {
        try {
            this.emitTask(runnable, eventFunction);
        }
        catch (IOException e) {
            Throwables.propagate((Throwable)e);
        }
    }

    private void emitTask(CheckedRunnable runnable, Function<Task, Event> eventFunction) throws IOException, InterruptedException {
        Optional<Object> failure = Optional.empty();
        OffsetDateTime startTime = this.clock.instant().atOffset(ZoneOffset.UTC);
        try {
            runnable.run();
        }
        catch (IOException | InterruptedException | RuntimeException e) {
            failure = Optional.of(Exceptions.condensedStacktraceFor(e));
            throw e;
        }
        finally {
            OffsetDateTime endTime = this.clock.instant().atOffset(ZoneOffset.UTC);
            Task task = Task.builder().startTime(startTime).endTime(endTime).failure(failure).build();
            Event event = eventFunction.apply(task);
            this.emitEvent(event);
        }
    }

    private void emitEvent(Event event) {
        ArrayList exceptions = new ArrayList();
        this.eventConsumers.forEach(eventConsumer -> {
            try {
                eventConsumer.receiveEvent(event);
            }
            catch (Exception e) {
                log.error("Error sending event {}", (Object)event, (Object)e);
                exceptions.add(e);
            }
        });
        if (exceptions.isEmpty()) {
            return;
        }
        RuntimeException exception = new RuntimeException("There were exceptions when emitting an event");
        exceptions.forEach(exception::addSuppressed);
        throw exception;
    }

    static interface InterruptableClusterWait {
        public void waitForCluster(Cluster var1) throws InterruptedException;
    }

    static interface CheckedRunnable {
        public void run() throws InterruptedException, IOException;
    }
}

