/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.docker.compose;

import com.palantir.docker.compose.RecordingCluster;
import com.palantir.docker.compose.connection.Cluster;
import com.palantir.docker.compose.connection.waiting.ClusterWait;
import com.palantir.docker.compose.events.ClusterWaitType;
import java.util.Optional;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class RecordingClusterWait {
    private static final Logger log = LoggerFactory.getLogger(RecordingClusterWait.class);
    private final ClusterWait clusterWait;
    private final ClusterWaitType clusterWaitType;
    private Optional<Set<String>> recordedServiceNames = Optional.empty();

    RecordingClusterWait(ClusterWait clusterWait, ClusterWaitType clusterWaitType) {
        this.clusterWait = clusterWait;
        this.clusterWaitType = clusterWaitType;
    }

    public void waitForCluster(Cluster cluster) {
        RecordingCluster recordingCluster = new RecordingCluster(cluster);
        try {
            this.clusterWait.waitUntilReady(recordingCluster);
            log.info("Cluster wait for services {} (type: {}) successfully finished", recordingCluster.recordedContainerNames(), (Object)this.clusterWaitType.toString().toLowerCase());
        }
        catch (Exception e) {
            if (e.getMessage() != null) {
                log.error("Cluster wait for services {} (type: {}) timed out with exception:\n\t{}", new Object[]{recordingCluster.recordedContainerNames(), this.clusterWaitType.toString().toLowerCase(), e.getMessage()});
            }
            throw e;
        }
        finally {
            this.recordedServiceNames = Optional.of(recordingCluster.recordedContainerNames());
        }
    }

    public Set<String> recordedServiceNames() {
        return this.recordedServiceNames.orElseThrow(() -> new IllegalStateException("Recorded service names have not yet been computed"));
    }
}

