/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.docker.compose.configuration;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.Map;
import java.util.stream.Collectors;

public final class AdditionalEnvironmentValidator {
    private static final ImmutableSet<String> ILLEGAL_VARIABLES = ImmutableSet.of((Object)"DOCKER_TLS_VERIFY", (Object)"DOCKER_HOST", (Object)"DOCKER_CERT_PATH");

    private AdditionalEnvironmentValidator() {
    }

    public static Map<String, String> validate(Map<String, String> additionalEnvironment) {
        Sets.SetView invalidVariables = Sets.intersection(additionalEnvironment.keySet(), ILLEGAL_VARIABLES);
        String errorMessage = invalidVariables.stream().collect(Collectors.joining(", ", "The following variables: ", " cannot exist in your additional environment variable block as they will interfere with Docker."));
        Preconditions.checkState((boolean)invalidVariables.isEmpty(), (Object)errorMessage);
        return additionalEnvironment;
    }
}

