/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.docker.compose.configuration;

import com.google.common.base.Preconditions;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableSet;
import com.palantir.docker.compose.configuration.EnvironmentValidator;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;

public final class DaemonEnvironmentValidator
implements EnvironmentValidator {
    private static final Set<String> ILLEGAL_VARIABLES = ImmutableSet.of((Object)"DOCKER_TLS_VERIFY", (Object)"DOCKER_HOST", (Object)"DOCKER_CERT_PATH");
    private static final Supplier<DaemonEnvironmentValidator> SUPPLIER = Suppliers.memoize(() -> new DaemonEnvironmentValidator());

    public static DaemonEnvironmentValidator instance() {
        return SUPPLIER.get();
    }

    private DaemonEnvironmentValidator() {
    }

    @Override
    public void validateEnvironmentVariables(Map<String, String> dockerEnvironment) {
        Set invalidVariables = ILLEGAL_VARIABLES.stream().filter(dockerEnvironment::containsKey).collect(Collectors.toSet());
        String errorMessage = invalidVariables.stream().collect(Collectors.joining(", ", "These variables were set: ", ". They cannot be set when connecting to a local docker daemon."));
        Preconditions.checkState((boolean)invalidVariables.isEmpty(), (Object)errorMessage);
    }
}

