/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.docker.compose.configuration;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.io.File;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;

public final class DockerComposeFiles {
    private final List<File> dockerComposeFiles;

    public DockerComposeFiles(List<File> dockerComposeFiles) {
        this.dockerComposeFiles = dockerComposeFiles;
    }

    public static DockerComposeFiles from(String ... dockerComposeFilenames) {
        List<File> dockerComposeFiles = Lists.newArrayList((Object[])dockerComposeFilenames).stream().map(File::new).collect(Collectors.toList());
        DockerComposeFiles.validateAtLeastOneComposeFileSpecified(dockerComposeFiles);
        DockerComposeFiles.validateComposeFilesExist(dockerComposeFiles);
        return new DockerComposeFiles(dockerComposeFiles);
    }

    public List<String> constructComposeFileCommand() {
        return this.dockerComposeFiles.stream().map(File::getAbsolutePath).map(f -> Lists.newArrayList((Object[])new String[]{"--file", f})).flatMap(Collection::stream).collect(Collectors.toList());
    }

    private static void validateAtLeastOneComposeFileSpecified(List<File> dockerComposeFiles) {
        Preconditions.checkArgument((!dockerComposeFiles.isEmpty() ? 1 : 0) != 0, (Object)"A docker compose file must be specified.");
    }

    private static void validateComposeFilesExist(List<File> dockerComposeFiles) {
        List missingFiles = dockerComposeFiles.stream().filter(f -> !f.exists()).collect(Collectors.toList());
        String errorMessage = missingFiles.stream().map(File::getAbsolutePath).collect(Collectors.joining(", ", "The following docker-compose files: ", " do not exist."));
        Preconditions.checkState((boolean)missingFiles.isEmpty(), (Object)errorMessage);
    }
}

