/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.docker.compose.configuration;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.palantir.docker.compose.configuration.ImmutableProjectName;
import com.palantir.docker.compose.configuration.PackageVisible;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import org.immutables.value.Value;

@Value.Immutable
@PackageVisible
public abstract class ProjectName {
    @Value.Parameter
    protected abstract Optional<String> projectName();

    @Value.Check
    protected void validate() {
        if (!this.projectName().isPresent()) {
            return;
        }
        Preconditions.checkState((this.projectName().get().trim().length() > 0 ? 1 : 0) != 0, (Object)"ProjectName must not be blank. If you want to omit the project name, use ProjectName.omit()");
        Preconditions.checkState((boolean)this.validCharacters(this.projectName().get()), (String)"ProjectName '%s' not allowed, please use lowercase letters and numbers only.", (Object)this.projectName().get());
    }

    protected boolean validCharacters(String projectName) {
        Predicate<String> illegalCharacters = Pattern.compile("[^a-z0-9]").asPredicate();
        return !illegalCharacters.test(projectName);
    }

    public String asString() {
        return this.projectName().orElseThrow(() -> new IllegalStateException("Cannot get the ProjectName as string if the ProjectName is omitted"));
    }

    public List<String> constructComposeFileCommand() {
        return (List)this.projectName().map(projectName -> ImmutableList.of((Object)"--project-name", (Object)projectName)).orElseGet(ImmutableList::of);
    }

    public static ProjectName random() {
        return ImmutableProjectName.of(Optional.of(UUID.randomUUID().toString().substring(0, 8)));
    }

    public static ProjectName fromString(String name) {
        return ImmutableProjectName.of(Optional.of(name));
    }

    public static ProjectName omit() {
        return ImmutableProjectName.of(Optional.empty());
    }
}

