/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.docker.compose.configuration;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.palantir.docker.compose.configuration.EnvironmentValidator;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public final class RemoteEnvironmentValidator
implements EnvironmentValidator {
    private static final Set<String> SECURE_VARIABLES = ImmutableSet.of((Object)"DOCKER_TLS_VERIFY", (Object)"DOCKER_CERT_PATH");
    private static final RemoteEnvironmentValidator VALIDATOR = new RemoteEnvironmentValidator();

    public static RemoteEnvironmentValidator instance() {
        return VALIDATOR;
    }

    private RemoteEnvironmentValidator() {
    }

    @Override
    public void validateEnvironmentVariables(Map<String, String> dockerEnvironment) {
        Collection<String> missingVariables = RemoteEnvironmentValidator.getMissingEnvVariables(dockerEnvironment);
        String errorMessage = missingVariables.stream().collect(Collectors.joining(", ", "Missing required environment variables: ", ". Please run `docker-machine env <machine-name>` and ensure they are set on the DockerComposition."));
        Preconditions.checkState((boolean)missingVariables.isEmpty(), (Object)errorMessage);
    }

    private static Collection<String> getMissingEnvVariables(Map<String, String> dockerEnvironment) {
        Sets.SetView requiredVariables = Sets.union((Set)Sets.newHashSet((Object[])new String[]{"DOCKER_HOST"}), RemoteEnvironmentValidator.secureVariablesRequired(dockerEnvironment));
        return requiredVariables.stream().filter(envVariable -> Strings.isNullOrEmpty((String)((String)dockerEnvironment.get(envVariable)))).collect(Collectors.toSet());
    }

    private static Set<String> secureVariablesRequired(Map<String, String> dockerEnvironment) {
        return RemoteEnvironmentValidator.certVerificationEnabled(dockerEnvironment) ? SECURE_VARIABLES : new HashSet();
    }

    private static boolean certVerificationEnabled(Map<String, String> dockerEnvironment) {
        return dockerEnvironment.containsKey("DOCKER_TLS_VERIFY");
    }
}

