/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.docker.compose.connection;

import com.google.common.base.Suppliers;
import com.google.common.base.Throwables;
import com.palantir.docker.compose.connection.DockerPort;
import com.palantir.docker.compose.connection.Ports;
import com.palantir.docker.compose.connection.State;
import com.palantir.docker.compose.connection.waiting.SuccessOrFailure;
import com.palantir.docker.compose.execution.Docker;
import com.palantir.docker.compose.execution.DockerCompose;
import java.io.IOException;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;

public final class Container {
    private final String containerName;
    private final Docker docker;
    private final DockerCompose dockerCompose;
    private Supplier<Ports> portMappings = Suppliers.memoize(this::getDockerPorts);

    public Container(String containerName, Docker docker, DockerCompose dockerCompose) {
        this.containerName = containerName;
        this.docker = docker;
        this.dockerCompose = dockerCompose;
    }

    public String getContainerName() {
        return this.containerName;
    }

    public SuccessOrFailure portIsListeningOnHttpAndCheckStatus2xx(int internalPort, Function<DockerPort, String> urlFunction) {
        return this.portIsListeningOnHttp(internalPort, urlFunction, true);
    }

    public SuccessOrFailure portIsListeningOnHttp(int internalPort, Function<DockerPort, String> urlFunction) {
        return this.portIsListeningOnHttp(internalPort, urlFunction, false);
    }

    public SuccessOrFailure portIsListeningOnHttp(int internalPort, Function<DockerPort, String> urlFunction, boolean andCheckStatus) {
        try {
            DockerPort port = this.port(internalPort);
            if (!port.isListeningNow()) {
                return SuccessOrFailure.failure("Internal port " + internalPort + " is not listening in container " + this.containerName);
            }
            return port.isHttpRespondingSuccessfully(urlFunction, andCheckStatus).mapFailure(failureMessage -> internalPort + " does not have a http response from " + (String)urlFunction.apply(port) + ":\n" + failureMessage);
        }
        catch (Exception e) {
            return SuccessOrFailure.fromException(e);
        }
    }

    public DockerPort portMappedExternallyTo(int externalPort) {
        return this.portMappings.get().stream().filter(port -> port.getExternalPort() == externalPort).findFirst().orElseThrow(() -> new IllegalArgumentException("No port mapped externally to '" + externalPort + "' for container '" + this.containerName + "'"));
    }

    @Deprecated
    public DockerPort portMappedInternallyTo(int internalPort) {
        return this.port(internalPort);
    }

    public DockerPort port(int internalPort) {
        Ports ports = this.portMappings.get();
        return ports.stream().filter(port -> port.getInternalPort() == internalPort).findFirst().orElseThrow(() -> new IllegalArgumentException("No internal port '" + internalPort + "' for container '" + this.containerName + "': " + ports));
    }

    public void start() throws IOException, InterruptedException {
        this.dockerCompose.start(this);
        this.portMappings = Suppliers.memoize(this::getDockerPorts);
    }

    public void stop() throws IOException, InterruptedException {
        this.dockerCompose.stop(this);
    }

    public void kill() throws IOException, InterruptedException {
        this.dockerCompose.kill(this);
    }

    public State state() throws IOException, InterruptedException {
        String id = this.dockerCompose.id(this).orElse(null);
        if (id == null) {
            return State.DOWN;
        }
        return this.docker.state(id);
    }

    public void up() throws IOException, InterruptedException {
        this.dockerCompose.up(this);
    }

    public Ports ports() {
        return this.portMappings.get();
    }

    private Ports getDockerPorts() {
        try {
            return this.dockerCompose.ports(this.containerName);
        }
        catch (IOException | InterruptedException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        Container container = (Container)object;
        return Objects.equals(this.containerName, container.containerName);
    }

    public int hashCode() {
        return Objects.hashCode(this.containerName);
    }

    public String toString() {
        return "Container{containerName='" + this.containerName + "'}";
    }

    public SuccessOrFailure areAllPortsOpen() {
        List unavaliablePorts = this.portMappings.get().stream().filter(port -> !port.isListeningNow()).map(DockerPort::getInternalPort).collect(Collectors.toList());
        boolean allPortsOpen = unavaliablePorts.isEmpty();
        String failureMessage = "The following ports failed to open: " + unavaliablePorts;
        return SuccessOrFailure.fromBoolean(allPortsOpen, failureMessage);
    }
}

