/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.docker.compose.connection;

import com.palantir.docker.compose.connection.Container;
import com.palantir.docker.compose.execution.Docker;
import com.palantir.docker.compose.execution.DockerCompose;
import java.io.IOException;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;

public final class ContainerCache {
    private final ConcurrentMap<String, Container> containers = new ConcurrentHashMap<String, Container>();
    private final Docker docker;
    private final DockerCompose dockerCompose;

    public ContainerCache(Docker docker, DockerCompose dockerCompose) {
        this.docker = docker;
        this.dockerCompose = dockerCompose;
    }

    public Container container(String containerName) {
        return this.containers.computeIfAbsent(containerName, _ignored -> new Container(containerName, this.docker, this.dockerCompose));
    }

    public Set<Container> containers() throws IOException, InterruptedException {
        return this.dockerCompose.services().stream().map(this::container).collect(Collectors.toSet());
    }
}

