/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.docker.compose.connection;

import com.google.common.base.Splitter;
import com.palantir.docker.compose.connection.ImmutableContainerName;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.immutables.value.Value;

@Value.Immutable
public abstract class ContainerName {
    public abstract String rawName();

    public abstract String semanticName();

    public String toString() {
        return this.semanticName();
    }

    public static ContainerName fromPsLine(String psLine) {
        List lineComponents = Splitter.on((String)" ").splitToList((CharSequence)psLine);
        String rawName = (String)lineComponents.get(0);
        if (ContainerName.probablyCustomName(rawName)) {
            return ImmutableContainerName.builder().rawName(rawName).semanticName(rawName).build();
        }
        String semanticName = ContainerName.withoutDirectory(ContainerName.withoutScaleNumber(rawName));
        return ImmutableContainerName.builder().rawName(rawName).semanticName(semanticName).build();
    }

    private static boolean probablyCustomName(String rawName) {
        return rawName.split("_").length < 3;
    }

    private static String withoutDirectory(String rawName) {
        return Arrays.stream(rawName.split("_")).skip(1L).collect(Collectors.joining("_"));
    }

    public static String withoutScaleNumber(String rawName) {
        String[] components = rawName.split("_");
        return Arrays.stream(components).limit(components.length - 1).collect(Collectors.joining("_"));
    }
}

