/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.docker.compose.connection;

import com.google.common.base.Splitter;
import com.palantir.docker.compose.connection.ContainerName;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public final class ContainerNames {
    private static final Pattern HEAD_PATTERN = Pattern.compile("-+(\r|\n)+");
    private static final Pattern BODY_PATTERN = Pattern.compile("(\r|\n)+");

    private ContainerNames() {
    }

    public static List<ContainerName> parseFromDockerComposePs(String psOutput) {
        List psHeadAndBody = Splitter.on((Pattern)HEAD_PATTERN).splitToList((CharSequence)psOutput);
        if (psHeadAndBody.size() < 2) {
            return Collections.emptyList();
        }
        String psBody = (String)psHeadAndBody.get(1);
        return ContainerNames.psBodyLines(psBody).map(ContainerName::fromPsLine).collect(Collectors.toList());
    }

    private static Stream<String> psBodyLines(String psBody) {
        List lines = Splitter.on((Pattern)BODY_PATTERN).splitToList((CharSequence)psBody);
        return lines.stream().map(String::trim).filter(line -> !line.isEmpty());
    }
}

