/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.docker.compose.connection;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import com.palantir.docker.compose.configuration.AdditionalEnvironmentValidator;
import com.palantir.docker.compose.configuration.DockerType;
import com.palantir.docker.compose.configuration.RemoteHostIpResolver;
import com.palantir.docker.compose.execution.DockerConfiguration;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DockerMachine
implements DockerConfiguration {
    private static final Logger log = LoggerFactory.getLogger(DockerMachine.class);
    private static final DockerType FALLBACK_DOCKER_TYPE = DockerType.DAEMON;
    private final String hostIp;
    private final Map<String, String> environment;

    public DockerMachine(String hostIp, Map<String, String> environment) {
        this.hostIp = hostIp;
        this.environment = environment;
    }

    public String getIp() {
        return this.hostIp;
    }

    @Override
    public ProcessBuilder configuredDockerComposeProcess() {
        ProcessBuilder process = new ProcessBuilder(new String[0]);
        this.augmentGivenEnvironment(process.environment());
        return process;
    }

    private void augmentGivenEnvironment(Map<String, String> environmentToAugment) {
        environmentToAugment.putAll(this.environment);
    }

    public static LocalBuilder localMachine() {
        Map<String, String> systemEnv = System.getenv();
        Optional<DockerType> dockerType = DockerType.getFirstValidDockerTypeForEnvironment(systemEnv);
        if (!dockerType.isPresent()) {
            log.debug("Failed to determine Docker type (daemon or remote) based on current environment. Proceeding with {} as the type.", (Object)FALLBACK_DOCKER_TYPE);
        }
        return new LocalBuilder(dockerType.orElse(FALLBACK_DOCKER_TYPE), systemEnv);
    }

    public static LocalBuilder localMachine(DockerType dockerType) {
        return new LocalBuilder(dockerType, System.getenv());
    }

    public static RemoteBuilder remoteMachine() {
        return new RemoteBuilder();
    }

    public static final class RemoteBuilder {
        private final Map<String, String> dockerEnvironment = new HashMap<String, String>();
        private Map<String, String> additionalEnvironment = new HashMap<String, String>();

        private RemoteBuilder() {
        }

        public RemoteBuilder host(String hostname) {
            this.dockerEnvironment.put("DOCKER_HOST", hostname);
            return this;
        }

        public RemoteBuilder withTLS(String certPath) {
            this.dockerEnvironment.put("DOCKER_TLS_VERIFY", "1");
            this.dockerEnvironment.put("DOCKER_CERT_PATH", certPath);
            return this;
        }

        public RemoteBuilder withoutTLS() {
            this.dockerEnvironment.remove("DOCKER_TLS_VERIFY");
            this.dockerEnvironment.remove("DOCKER_CERT_PATH");
            return this;
        }

        public RemoteBuilder withAdditionalEnvironmentVariable(String key, String value) {
            this.additionalEnvironment.put(key, value);
            return this;
        }

        public RemoteBuilder withEnvironment(Map<String, String> newEnvironment) {
            this.additionalEnvironment = new HashMap<String, String>((Map)MoreObjects.firstNonNull(newEnvironment, new HashMap()));
            return this;
        }

        public DockerMachine build() {
            DockerType.REMOTE.validateEnvironmentVariables(this.dockerEnvironment);
            AdditionalEnvironmentValidator.validate(this.additionalEnvironment);
            String dockerHost = this.dockerEnvironment.getOrDefault("DOCKER_HOST", "");
            String hostIp = new RemoteHostIpResolver().resolveIp(dockerHost);
            ImmutableMap environment = ImmutableMap.builder().put((Object)"COLUMNS", (Object)"10000").putAll(this.dockerEnvironment).putAll(this.additionalEnvironment).build();
            return new DockerMachine(hostIp, (Map<String, String>)environment);
        }
    }

    public static final class LocalBuilder {
        private final DockerType dockerType;
        private final Map<String, String> systemEnvironment;
        private Map<String, String> additionalEnvironment = new HashMap<String, String>();

        LocalBuilder(DockerType dockerType, Map<String, String> systemEnvironment) {
            this.dockerType = dockerType;
            this.systemEnvironment = ImmutableMap.copyOf(systemEnvironment);
        }

        public LocalBuilder withAdditionalEnvironmentVariable(String key, String value) {
            this.additionalEnvironment.put(key, value);
            return this;
        }

        public LocalBuilder withEnvironment(Map<String, String> newEnvironment) {
            this.additionalEnvironment = new HashMap<String, String>((Map)MoreObjects.firstNonNull(newEnvironment, new HashMap()));
            return this;
        }

        public DockerMachine build() {
            this.dockerType.validateEnvironmentVariables(this.systemEnvironment);
            AdditionalEnvironmentValidator.validate(this.additionalEnvironment);
            HashMap<String, String> combinedEnvironment = new HashMap<String, String>();
            combinedEnvironment.putAll(this.systemEnvironment);
            combinedEnvironment.putAll(this.additionalEnvironment);
            String dockerHost = this.systemEnvironment.getOrDefault("DOCKER_HOST", "");
            return new DockerMachine(this.dockerType.resolveIp(dockerHost), (Map<String, String>)ImmutableMap.copyOf(combinedEnvironment));
        }
    }
}

