/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.docker.compose.connection;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.palantir.docker.compose.connection.Cluster;
import com.palantir.docker.compose.connection.ContainerCache;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="Cluster", generator="Immutables")
@Immutable
public final class ImmutableCluster
extends Cluster {
    private final String ip;
    private final ContainerCache containerCache;

    private ImmutableCluster(String ip, ContainerCache containerCache) {
        this.ip = ip;
        this.containerCache = containerCache;
    }

    @Override
    public String ip() {
        return this.ip;
    }

    @Override
    public ContainerCache containerCache() {
        return this.containerCache;
    }

    public final ImmutableCluster withIp(String value) {
        String newValue = Objects.requireNonNull(value, "ip");
        if (this.ip.equals(newValue)) {
            return this;
        }
        return new ImmutableCluster(newValue, this.containerCache);
    }

    public final ImmutableCluster withContainerCache(ContainerCache value) {
        if (this.containerCache == value) {
            return this;
        }
        ContainerCache newValue = Objects.requireNonNull(value, "containerCache");
        return new ImmutableCluster(this.ip, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableCluster && this.equalTo((ImmutableCluster)another);
    }

    private boolean equalTo(ImmutableCluster another) {
        return this.ip.equals(another.ip) && this.containerCache.equals(another.containerCache);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.ip.hashCode();
        h += (h << 5) + this.containerCache.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"Cluster").omitNullValues().add("ip", (Object)this.ip).add("containerCache", (Object)this.containerCache).toString();
    }

    public static ImmutableCluster copyOf(Cluster instance) {
        if (instance instanceof ImmutableCluster) {
            return (ImmutableCluster)instance;
        }
        return ImmutableCluster.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="Cluster", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_IP = 1L;
        private static final long INIT_BIT_CONTAINER_CACHE = 2L;
        private long initBits = 3L;
        @Nullable
        private String ip;
        @Nullable
        private ContainerCache containerCache;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(Cluster instance) {
            Objects.requireNonNull(instance, "instance");
            this.ip(instance.ip());
            this.containerCache(instance.containerCache());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder ip(String ip) {
            this.ip = Objects.requireNonNull(ip, "ip");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder containerCache(ContainerCache containerCache) {
            this.containerCache = Objects.requireNonNull(containerCache, "containerCache");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableCluster build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableCluster(this.ip, this.containerCache);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("ip");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("containerCache");
            }
            return "Cannot build Cluster, some of required attributes are not set " + attributes;
        }
    }
}

