/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.docker.compose.connection;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.palantir.docker.compose.connection.ContainerName;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="ContainerName", generator="Immutables")
@Immutable
public final class ImmutableContainerName
extends ContainerName {
    private final String rawName;
    private final String semanticName;

    private ImmutableContainerName(String rawName, String semanticName) {
        this.rawName = rawName;
        this.semanticName = semanticName;
    }

    @Override
    public String rawName() {
        return this.rawName;
    }

    @Override
    public String semanticName() {
        return this.semanticName;
    }

    public final ImmutableContainerName withRawName(String value) {
        String newValue = Objects.requireNonNull(value, "rawName");
        if (this.rawName.equals(newValue)) {
            return this;
        }
        return new ImmutableContainerName(newValue, this.semanticName);
    }

    public final ImmutableContainerName withSemanticName(String value) {
        String newValue = Objects.requireNonNull(value, "semanticName");
        if (this.semanticName.equals(newValue)) {
            return this;
        }
        return new ImmutableContainerName(this.rawName, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableContainerName && this.equalTo((ImmutableContainerName)another);
    }

    private boolean equalTo(ImmutableContainerName another) {
        return this.rawName.equals(another.rawName) && this.semanticName.equals(another.semanticName);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.rawName.hashCode();
        h += (h << 5) + this.semanticName.hashCode();
        return h;
    }

    public static ImmutableContainerName copyOf(ContainerName instance) {
        if (instance instanceof ImmutableContainerName) {
            return (ImmutableContainerName)instance;
        }
        return ImmutableContainerName.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="ContainerName", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_RAW_NAME = 1L;
        private static final long INIT_BIT_SEMANTIC_NAME = 2L;
        private long initBits = 3L;
        @Nullable
        private String rawName;
        @Nullable
        private String semanticName;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(ContainerName instance) {
            Objects.requireNonNull(instance, "instance");
            this.rawName(instance.rawName());
            this.semanticName(instance.semanticName());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder rawName(String rawName) {
            this.rawName = Objects.requireNonNull(rawName, "rawName");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder semanticName(String semanticName) {
            this.semanticName = Objects.requireNonNull(semanticName, "semanticName");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableContainerName build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableContainerName(this.rawName, this.semanticName);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("rawName");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("semanticName");
            }
            return "Cannot build ContainerName, some of required attributes are not set " + attributes;
        }
    }
}

