/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.docker.compose.connection.waiting;

import com.palantir.docker.compose.connection.Cluster;
import com.palantir.docker.compose.connection.Container;
import com.palantir.docker.compose.connection.State;
import com.palantir.docker.compose.connection.waiting.HealthCheck;
import com.palantir.docker.compose.connection.waiting.SuccessOrFailure;
import java.io.IOException;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;

@FunctionalInterface
public interface ClusterHealthCheck {
    public static ClusterHealthCheck serviceHealthCheck(List<String> containerNames, HealthCheck<List<Container>> delegate) {
        return ClusterHealthCheck.transformingHealthCheck(cluster -> cluster.containers(containerNames), delegate);
    }

    public static ClusterHealthCheck serviceHealthCheck(String containerName, HealthCheck<Container> containerCheck) {
        return ClusterHealthCheck.transformingHealthCheck(cluster -> cluster.container(containerName), containerCheck);
    }

    public static <T> ClusterHealthCheck transformingHealthCheck(Function<Cluster, T> transform, HealthCheck<T> healthCheck) {
        return cluster -> {
            Object target = transform.apply(cluster);
            return healthCheck.isHealthy(target);
        };
    }

    public static ClusterHealthCheck nativeHealthChecks() {
        return cluster -> {
            LinkedHashSet<String> unhealthyContainers = new LinkedHashSet<String>();
            try {
                for (Container container : cluster.allContainers()) {
                    State state = container.state();
                    if (state != State.UNHEALTHY) continue;
                    unhealthyContainers.add(container.getContainerName());
                }
                if (!unhealthyContainers.isEmpty()) {
                    return SuccessOrFailure.failure("The following containers are not healthy: " + unhealthyContainers.stream().collect(Collectors.joining(", ")));
                }
                return SuccessOrFailure.success();
            }
            catch (IOException e) {
                return SuccessOrFailure.fromException(e);
            }
        };
    }

    public SuccessOrFailure isClusterHealthy(Cluster var1) throws InterruptedException;
}

