/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.docker.compose.connection.waiting;

import com.palantir.docker.compose.connection.Cluster;
import com.palantir.docker.compose.connection.waiting.ClusterHealthCheck;
import com.palantir.docker.compose.connection.waiting.SuccessOrFailure;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicReference;
import org.awaitility.Awaitility;
import org.awaitility.core.ConditionTimeoutException;
import org.joda.time.Duration;
import org.joda.time.ReadableDuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ClusterWait {
    private static final Logger log = LoggerFactory.getLogger(ClusterWait.class);
    private final ClusterHealthCheck clusterHealthCheck;
    private final Duration timeout;

    public ClusterWait(ClusterHealthCheck clusterHealthCheck, ReadableDuration timeout) {
        this.clusterHealthCheck = clusterHealthCheck;
        this.timeout = Duration.millis((long)timeout.getMillis());
    }

    public void waitUntilReady(Cluster cluster) {
        AtomicReference<Optional<SuccessOrFailure>> lastSuccessOrFailure = new AtomicReference<Optional<SuccessOrFailure>>(Optional.empty());
        Duration pollInterval = ClusterWait.minDuration(Duration.millis((long)500L), this.timeout.dividedBy(20L));
        try {
            Awaitility.await().pollInterval(java.time.Duration.ofMillis(pollInterval.getMillis())).pollDelay(java.time.Duration.ofMillis(ThreadLocalRandom.current().nextInt(1, 50))).atMost(java.time.Duration.ofMillis(this.timeout.getMillis())).until(this.weHaveSuccess(cluster, lastSuccessOrFailure));
        }
        catch (ConditionTimeoutException e) {
            throw new IllegalStateException(ClusterWait.serviceDidNotStartupExceptionMessage(lastSuccessOrFailure));
        }
    }

    private Callable<Boolean> weHaveSuccess(Cluster cluster, AtomicReference<Optional<SuccessOrFailure>> lastSuccessOrFailure) {
        return () -> {
            SuccessOrFailure successOrFailure = this.clusterHealthCheck.isClusterHealthy(cluster);
            lastSuccessOrFailure.set(Optional.of(successOrFailure));
            return successOrFailure.succeeded();
        };
    }

    private static String serviceDidNotStartupExceptionMessage(AtomicReference<Optional<SuccessOrFailure>> lastSuccessOrFailure) {
        String healthcheckFailureMessage = lastSuccessOrFailure.get().flatMap(SuccessOrFailure::toOptionalFailureMessage).orElse("The healthcheck did not finish before the timeout");
        return "The cluster failed to pass a startup check: " + healthcheckFailureMessage;
    }

    private static Duration minDuration(Duration first, Duration second) {
        if (first.isShorterThan((ReadableDuration)second)) {
            return first;
        }
        return second;
    }
}

