/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.docker.compose.connection.waiting;

import com.palantir.docker.compose.connection.Container;
import com.palantir.docker.compose.connection.DockerPort;
import com.palantir.docker.compose.connection.waiting.HealthCheck;
import java.util.function.Function;

public final class HealthChecks {
    private HealthChecks() {
    }

    public static HealthCheck<Container> toRespondOverHttp(int internalPort, Function<DockerPort, String> urlFunction) {
        return container -> container.portIsListeningOnHttp(internalPort, urlFunction);
    }

    public static HealthCheck<Container> toRespond2xxOverHttp(int internalPort, Function<DockerPort, String> urlFunction) {
        return container -> container.portIsListeningOnHttpAndCheckStatus2xx(internalPort, urlFunction);
    }

    public static HealthCheck<Container> toHaveAllPortsOpen() {
        return Container::areAllPortsOpen;
    }
}

