/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.docker.compose.connection.waiting;

import com.palantir.docker.compose.connection.waiting.Attempt;
import com.palantir.docker.compose.connection.waiting.Exceptions;
import com.palantir.docker.compose.connection.waiting.ImmutableSuccessOrFailure;
import java.util.Optional;
import java.util.function.Function;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.immutables.value.Value;

@Value.Immutable
public abstract class SuccessOrFailure {
    public static SuccessOrFailure onResultOf(Attempt attempt) {
        try {
            return SuccessOrFailure.fromBoolean(attempt.attempt(), "Attempt to complete healthcheck failed");
        }
        catch (Exception e) {
            return SuccessOrFailure.fromException(e);
        }
    }

    public SuccessOrFailure mapFailure(Function<String, String> mapper) {
        if (this.succeeded()) {
            return this;
        }
        return SuccessOrFailure.failure(mapper.apply(this.failureMessage()));
    }

    @Value.Parameter
    protected abstract Optional<String> optionalFailureMessage();

    public static SuccessOrFailure success() {
        return ImmutableSuccessOrFailure.of(Optional.empty());
    }

    public static SuccessOrFailure failure(String message) {
        return ImmutableSuccessOrFailure.of(Optional.of(message));
    }

    public static SuccessOrFailure failureWithCondensedException(String message, Exception exception) {
        return SuccessOrFailure.failure(message + ":\n" + Exceptions.condensedStacktraceFor(exception));
    }

    public static SuccessOrFailure fromBoolean(boolean succeeded, String possibleFailureMessage) {
        if (succeeded) {
            return SuccessOrFailure.success();
        }
        return SuccessOrFailure.failure(possibleFailureMessage);
    }

    public boolean failed() {
        return this.optionalFailureMessage().isPresent();
    }

    public boolean succeeded() {
        return !this.failed();
    }

    public String failureMessage() {
        return this.optionalFailureMessage().get();
    }

    public Optional<String> toOptionalFailureMessage() {
        return this.optionalFailureMessage();
    }

    public static SuccessOrFailure fromException(Exception exception) {
        return SuccessOrFailure.failure("Encountered an exception: " + ExceptionUtils.getStackTrace((Throwable)exception));
    }
}

