/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.docker.compose.execution;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.palantir.docker.compose.execution.DelegatingDockerCompose;
import com.palantir.docker.compose.execution.Docker;
import com.palantir.docker.compose.execution.DockerCompose;
import com.palantir.docker.compose.execution.DockerExecutionException;
import java.io.IOException;
import java.util.Collection;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ConflictingContainerRemovingDockerCompose
extends DelegatingDockerCompose {
    private static final Logger log = LoggerFactory.getLogger(ConflictingContainerRemovingDockerCompose.class);
    private static final Pattern NAME_CONFLICT_PATTERN = Pattern.compile("name \"([^\"]*)\" is already in use");
    private final Docker docker;
    private final int retryAttempts;

    public ConflictingContainerRemovingDockerCompose(DockerCompose dockerCompose, Docker docker) {
        this(dockerCompose, docker, 1);
    }

    public ConflictingContainerRemovingDockerCompose(DockerCompose dockerCompose, Docker docker, int retryAttempts) {
        super(dockerCompose);
        Preconditions.checkArgument((retryAttempts >= 1 ? 1 : 0) != 0, (Object)("retryAttempts must be at least 1, was " + retryAttempts));
        this.docker = docker;
        this.retryAttempts = retryAttempts;
    }

    @Override
    public void up() throws IOException, InterruptedException {
        for (int currRetryAttempt = 0; currRetryAttempt <= this.retryAttempts; ++currRetryAttempt) {
            try {
                this.getDockerCompose().up();
                return;
            }
            catch (DockerExecutionException e) {
                Set<String> conflictingContainerNames = this.getConflictingContainerNames(e.getMessage());
                if (conflictingContainerNames.isEmpty()) {
                    throw e;
                }
                log.debug("docker-compose up failed due to container name conflicts (container names: {}). Removing containers and attempting docker-compose up again (attempt {}).", conflictingContainerNames, (Object)(currRetryAttempt + 1));
                this.removeContainers(conflictingContainerNames);
                continue;
            }
        }
        throw new DockerExecutionException("docker-compose up failed");
    }

    private void removeContainers(Collection<String> containerNames) throws IOException, InterruptedException {
        try {
            this.docker.rm(containerNames);
        }
        catch (DockerExecutionException e) {
            log.debug("docker rm failed, but continuing execution", (Throwable)e);
        }
    }

    Set<String> getConflictingContainerNames(String output) {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        Matcher matcher = NAME_CONFLICT_PATTERN.matcher(output);
        while (matcher.find()) {
            builder.add((Object)matcher.group(1));
        }
        return builder.build();
    }
}

