/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.docker.compose.execution;

import com.github.zafarkhaja.semver.Version;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.palantir.docker.compose.configuration.DockerComposeFiles;
import com.palantir.docker.compose.configuration.ProjectName;
import com.palantir.docker.compose.connection.Container;
import com.palantir.docker.compose.connection.ContainerName;
import com.palantir.docker.compose.connection.ContainerNames;
import com.palantir.docker.compose.connection.DockerMachine;
import com.palantir.docker.compose.connection.Ports;
import com.palantir.docker.compose.execution.Command;
import com.palantir.docker.compose.execution.DockerCompose;
import com.palantir.docker.compose.execution.DockerComposeExecArgument;
import com.palantir.docker.compose.execution.DockerComposeExecOption;
import com.palantir.docker.compose.execution.DockerComposeExecutable;
import com.palantir.docker.compose.execution.DockerComposeRunArgument;
import com.palantir.docker.compose.execution.DockerComposeRunOption;
import com.palantir.docker.compose.execution.DockerComposeVersion;
import com.palantir.docker.compose.execution.ErrorHandler;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.Validate;
import org.joda.time.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DefaultDockerCompose
implements DockerCompose {
    public static final Version VERSION_1_7_0 = Version.valueOf((String)"1.7.0");
    private static final Duration LOG_TIMEOUT = Duration.standardMinutes((long)1L);
    private static final Logger log = LoggerFactory.getLogger(DefaultDockerCompose.class);
    private final Command command;
    private final DockerMachine dockerMachine;
    private final DockerComposeExecutable rawExecutable;

    public DefaultDockerCompose(DockerComposeFiles dockerComposeFiles, DockerMachine dockerMachine, ProjectName projectName) {
        this(DockerComposeExecutable.builder().dockerComposeFiles(dockerComposeFiles).dockerConfiguration(dockerMachine).projectName(projectName).build(), dockerMachine);
    }

    public DefaultDockerCompose(DockerComposeExecutable rawExecutable, DockerMachine dockerMachine) {
        this.rawExecutable = rawExecutable;
        this.command = new Command(rawExecutable, arg_0 -> ((Logger)log).trace(arg_0));
        this.dockerMachine = dockerMachine;
    }

    @Override
    public void pull() throws IOException, InterruptedException {
        this.command.execute(Command.throwingOnError(), "pull");
    }

    @Override
    public void build() throws IOException, InterruptedException {
        this.command.execute(Command.throwingOnError(), "build");
    }

    @Override
    public void up() throws IOException, InterruptedException {
        this.command.execute(Command.throwingOnError(), "up", "-d");
    }

    @Override
    public void up(Container container) throws IOException, InterruptedException {
        this.command.execute(Command.throwingOnError(), "up", "-d", container.getContainerName());
    }

    @Override
    public void down() throws IOException, InterruptedException {
        this.command.execute(DefaultDockerCompose.swallowingDownCommandDoesNotExist(), "down", "--volumes");
    }

    @Override
    public void stop() throws IOException, InterruptedException {
        this.command.execute(Command.throwingOnError(), "stop");
    }

    @Override
    public void stop(Container container) throws IOException, InterruptedException {
        this.command.execute(Command.throwingOnError(), "stop", container.getContainerName());
    }

    @Override
    public void kill() throws IOException, InterruptedException {
        this.command.execute(Command.throwingOnError(), "kill");
    }

    @Override
    public void kill(Container container) throws IOException, InterruptedException {
        this.command.execute(Command.throwingOnError(), "kill", container.getContainerName());
    }

    @Override
    public void rm() throws IOException, InterruptedException {
        this.command.execute(Command.throwingOnError(), "rm", "--force", "-v");
    }

    @Override
    public void start(Container container) throws IOException, InterruptedException {
        this.command.execute(Command.throwingOnError(), "start", container.getContainerName());
    }

    @Override
    public String exec(DockerComposeExecOption dockerComposeExecOption, String containerName, DockerComposeExecArgument dockerComposeExecArgument) throws IOException, InterruptedException {
        this.verifyDockerComposeVersionAtLeast(VERSION_1_7_0, "You need at least docker-compose 1.7 to run docker-compose exec");
        String[] fullArgs = DefaultDockerCompose.constructFullDockerComposeExecArguments(dockerComposeExecOption, containerName, dockerComposeExecArgument);
        return this.command.execute(Command.throwingOnError(), fullArgs);
    }

    @Override
    public String run(DockerComposeRunOption dockerComposeRunOption, String containerName, DockerComposeRunArgument dockerComposeRunArgument) throws IOException, InterruptedException {
        String[] fullArgs = DefaultDockerCompose.constructFullDockerComposeRunArguments(dockerComposeRunOption, containerName, dockerComposeRunArgument);
        return this.command.execute(Command.throwingOnError(), fullArgs);
    }

    private void verifyDockerComposeVersionAtLeast(Version targetVersion, String message) throws IOException, InterruptedException {
        Validate.validState((boolean)this.version().greaterThanOrEqualTo(targetVersion), (String)message, (Object[])new Object[0]);
    }

    @Override
    private Version version() throws IOException, InterruptedException {
        String versionOutput = this.command.execute(Command.throwingOnError(), "-v");
        return DockerComposeVersion.parseFromDockerComposeVersion(versionOutput);
    }

    private static String[] constructFullDockerComposeExecArguments(DockerComposeExecOption dockerComposeExecOption, String containerName, DockerComposeExecArgument dockerComposeExecArgument) {
        ImmutableList fullArgs = new ImmutableList.Builder().add((Object)"exec").add((Object)"-T").addAll(dockerComposeExecOption.options()).add((Object)containerName).addAll(dockerComposeExecArgument.arguments()).build();
        return (String[])fullArgs.toArray((Object[])new String[fullArgs.size()]);
    }

    private static String[] constructFullDockerComposeRunArguments(DockerComposeRunOption dockerComposeRunOption, String containerName, DockerComposeRunArgument dockerComposeRunArgument) {
        ImmutableList fullArgs = new ImmutableList.Builder().add((Object)"run").addAll(dockerComposeRunOption.options()).add((Object)containerName).addAll(dockerComposeRunArgument.arguments()).build();
        return (String[])fullArgs.toArray((Object[])new String[fullArgs.size()]);
    }

    @Override
    public List<ContainerName> ps() throws IOException, InterruptedException {
        String psOutput = this.command.execute(Command.throwingOnError(), "ps");
        return ContainerNames.parseFromDockerComposePs(psOutput);
    }

    @Override
    public String config() throws IOException, InterruptedException {
        return this.command.execute(Command.throwingOnError(), "config");
    }

    @Override
    public List<String> services() throws IOException, InterruptedException {
        String servicesOutput = this.command.execute(Command.throwingOnError(), "config", "--services");
        return Arrays.asList(servicesOutput.split("(\r|\n)+"));
    }

    @Override
    public boolean writeLogs(String container, OutputStream output) throws IOException {
        try {
            boolean timedOut;
            Process executedProcess = this.logs(container);
            IOUtils.copy((InputStream)executedProcess.getInputStream(), (OutputStream)output);
            boolean processFinished = executedProcess.waitFor(LOG_TIMEOUT.getMillis(), TimeUnit.MILLISECONDS);
            boolean bl = timedOut = !processFinished;
            if (timedOut) {
                log.error("Log collection timed out after {} millis. Destroying log reading process for container {}", (Object)LOG_TIMEOUT.getMillis(), (Object)container);
                executedProcess.destroyForcibly();
            }
            return processFinished;
        }
        catch (InterruptedException e) {
            return false;
        }
    }

    @Override
    public Optional<String> id(Container container) throws IOException, InterruptedException {
        return this.id(container.getContainerName());
    }

    private Optional<String> id(String containerName) throws IOException, InterruptedException {
        String id = this.command.execute(Command.throwingOnError(), "ps", "-q", containerName);
        if (id.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(id);
    }

    private Process logs(String container) throws IOException, InterruptedException {
        this.verifyDockerComposeVersionAtLeast(VERSION_1_7_0, "You need at least docker-compose 1.7 to run docker-compose logs");
        return this.rawExecutable.execute("logs", "--no-color", container);
    }

    @Override
    public Ports ports(String service) throws IOException, InterruptedException {
        return Ports.parseFromDockerComposePs(this.psOutput(service), this.dockerMachine.getIp());
    }

    private static ErrorHandler swallowingDownCommandDoesNotExist() {
        return (exitCode, output, commandName, commands) -> {
            if (DefaultDockerCompose.downCommandWasPresent(output)) {
                Command.throwingOnError().handle(exitCode, output, commandName, commands);
            }
            log.warn("It looks like `docker-compose down` didn't work.");
            log.warn("This probably means your version of docker-compose doesn't support the `down` command");
            log.warn("Updating to version 1.6+ of docker-compose is likely to fix this issue.");
        };
    }

    private static boolean downCommandWasPresent(String output) {
        return !output.contains("No such command");
    }

    private String psOutput(String service) throws IOException, InterruptedException {
        String psOutput = this.command.execute(Command.throwingOnError(), "ps", service);
        Validate.validState((!Strings.isNullOrEmpty((String)psOutput) ? 1 : 0) != 0, (String)("No container with name '" + service + "' found"), (Object[])new Object[0]);
        return psOutput;
    }
}

