/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.docker.compose.execution;

import com.github.zafarkhaja.semver.Version;
import com.google.common.base.Preconditions;
import com.google.common.collect.ObjectArrays;
import com.palantir.docker.compose.connection.DockerMachine;
import com.palantir.docker.compose.connection.State;
import com.palantir.docker.compose.execution.Command;
import com.palantir.docker.compose.execution.DockerExecutable;
import java.io.IOException;
import java.util.Collection;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.SystemUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Docker {
    private static final Logger log = LoggerFactory.getLogger(Docker.class);
    private static final Pattern VERSION_PATTERN = Pattern.compile("^Docker version (\\d+)\\.(\\d+)\\.(\\d+)(?:-.*)?$");
    private static final String HEALTH_STATUS_FORMAT = "--format={{if not .State.Running}}DOWN{{else if .State.Paused}}PAUSED{{else if index .State \"Health\"}}{{if eq .State.Health.Status \"healthy\"}}HEALTHY{{else}}UNHEALTHY{{end}}{{else}}HEALTHY{{end}}";
    private static final String HEALTH_STATUS_FORMAT_WINDOWS = "--format={{if not .State.Running}}DOWN{{else if .State.Paused}}PAUSED{{else if index .State \"Health\"}}{{if eq .State.Health.Status \"healthy\"}}HEALTHY{{else}}UNHEALTHY{{end}}{{else}}HEALTHY{{end}}".replaceAll("\"", "`\"");
    private final Command command;

    public static Version version() throws IOException, InterruptedException {
        return new Docker(DockerExecutable.builder().dockerConfiguration(DockerMachine.localMachine().build()).build()).configuredVersion();
    }

    public Version configuredVersion() throws IOException, InterruptedException {
        String versionString = this.command.execute(Command.throwingOnError(), "-v");
        Matcher matcher = VERSION_PATTERN.matcher(versionString);
        Preconditions.checkState((boolean)matcher.matches(), (String)"Unexpected output of docker -v: %s", (Object)versionString);
        return Version.forIntegers((int)Integer.parseInt(matcher.group(1)), (int)Integer.parseInt(matcher.group(2)), (int)Integer.parseInt(matcher.group(3)));
    }

    public Docker(DockerExecutable rawExecutable) {
        this.command = new Command(rawExecutable, arg_0 -> ((Logger)log).trace(arg_0));
    }

    public State state(String containerId) throws IOException, InterruptedException {
        String formatString = SystemUtils.IS_OS_WINDOWS ? HEALTH_STATUS_FORMAT_WINDOWS : HEALTH_STATUS_FORMAT;
        String stateString = this.command.execute(Command.throwingOnError(), "inspect", formatString, containerId);
        return State.valueOf(stateString);
    }

    public void rm(Collection<String> containerNames) throws IOException, InterruptedException {
        this.rm(containerNames.toArray(new String[containerNames.size()]));
    }

    public void rm(String ... containerNames) throws IOException, InterruptedException {
        this.command.execute(Command.throwingOnError(), (String[])ObjectArrays.concat((Object[])new String[]{"rm", "-f"}, (Object[])containerNames, String.class));
    }

    public String listNetworks() throws IOException, InterruptedException {
        return this.command.execute(Command.throwingOnError(), "network", "ls");
    }

    public String pruneNetworks() throws IOException, InterruptedException {
        return this.command.execute(Command.throwingOnError(), "network", "prune", "--force");
    }
}

