/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.docker.compose.execution;

import com.github.zafarkhaja.semver.Version;
import com.google.common.collect.ImmutableList;
import com.palantir.docker.compose.configuration.DockerComposeFiles;
import com.palantir.docker.compose.configuration.ProjectName;
import com.palantir.docker.compose.execution.Command;
import com.palantir.docker.compose.execution.DockerCommandLocations;
import com.palantir.docker.compose.execution.DockerComposeVersion;
import com.palantir.docker.compose.execution.DockerConfiguration;
import com.palantir.docker.compose.execution.DockerForMacHostsIssue;
import com.palantir.docker.compose.execution.Executable;
import com.palantir.docker.compose.execution.ImmutableDockerComposeExecutable;
import java.io.IOException;
import java.util.List;
import org.immutables.value.Value;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Value.Immutable
public abstract class DockerComposeExecutable
implements Executable {
    private static final Logger log = LoggerFactory.getLogger(DockerComposeExecutable.class);
    private static final DockerCommandLocations DOCKER_COMPOSE_LOCATIONS = new DockerCommandLocations(System.getenv("DOCKER_COMPOSE_LOCATION"), "/usr/local/bin/docker-compose", "/usr/bin/docker-compose");

    private static String defaultDockerComposePath() {
        String pathToUse = DOCKER_COMPOSE_LOCATIONS.preferredLocation().orElseThrow(() -> new IllegalStateException("Could not find docker-compose, looked in: " + DOCKER_COMPOSE_LOCATIONS));
        log.debug("Using docker-compose found at " + pathToUse);
        return pathToUse;
    }

    static Version version() throws IOException, InterruptedException {
        Command dockerCompose = new Command(new Executable(){

            @Override
            public String commandName() {
                return "docker-compose";
            }

            @Override
            public Process execute(String ... commands) throws IOException {
                ImmutableList args = ImmutableList.builder().add((Object)DockerComposeExecutable.defaultDockerComposePath()).add((Object[])commands).build();
                return new ProcessBuilder((List<String>)args).redirectErrorStream(true).start();
            }
        }, arg_0 -> ((Logger)log).trace(arg_0));
        String versionOutput = dockerCompose.execute(Command.throwingOnError(), "-v");
        return DockerComposeVersion.parseFromDockerComposeVersion(versionOutput);
    }

    @Value.Parameter
    protected abstract DockerComposeFiles dockerComposeFiles();

    @Value.Parameter
    protected abstract DockerConfiguration dockerConfiguration();

    @Value.Default
    public ProjectName projectName() {
        return ProjectName.random();
    }

    @Override
    public final String commandName() {
        return "docker-compose";
    }

    @Value.Derived
    protected String dockerComposePath() {
        return DockerComposeExecutable.defaultDockerComposePath();
    }

    @Override
    public Process execute(String ... commands) throws IOException {
        DockerForMacHostsIssue.issueWarning();
        ImmutableList args = ImmutableList.builder().add((Object)this.dockerComposePath()).addAll(this.projectName().constructComposeFileCommand()).addAll(this.dockerComposeFiles().constructComposeFileCommand()).add((Object[])commands).build();
        return this.dockerConfiguration().configuredDockerComposeProcess().command((List<String>)args).redirectErrorStream(true).start();
    }

    public static ImmutableDockerComposeExecutable.Builder builder() {
        return ImmutableDockerComposeExecutable.builder();
    }
}

