/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.docker.compose.execution;

import com.google.common.collect.ImmutableList;
import com.palantir.docker.compose.execution.DockerCommandLocations;
import com.palantir.docker.compose.execution.DockerConfiguration;
import com.palantir.docker.compose.execution.Executable;
import com.palantir.docker.compose.execution.ImmutableDockerExecutable;
import java.io.IOException;
import java.util.List;
import org.immutables.value.Value;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Value.Immutable
public abstract class DockerExecutable
implements Executable {
    private static final Logger log = LoggerFactory.getLogger(DockerExecutable.class);
    private static final DockerCommandLocations DOCKER_LOCATIONS = new DockerCommandLocations(System.getenv("DOCKER_LOCATION"), "/usr/local/bin/docker", "/usr/bin/docker");

    @Value.Parameter
    protected abstract DockerConfiguration dockerConfiguration();

    @Override
    public final String commandName() {
        return "docker";
    }

    @Value.Derived
    protected String dockerPath() {
        String pathToUse = DOCKER_LOCATIONS.preferredLocation().orElseThrow(() -> new IllegalStateException("Could not find docker, looked in: " + DOCKER_LOCATIONS));
        log.debug("Using docker found at " + pathToUse);
        return pathToUse;
    }

    @Override
    public Process execute(String ... commands) throws IOException {
        ImmutableList args = ImmutableList.builder().add((Object)this.dockerPath()).add((Object[])commands).build();
        return this.dockerConfiguration().configuredDockerComposeProcess().command((List<String>)args).redirectErrorStream(true).start();
    }

    public static ImmutableDockerExecutable.Builder builder() {
        return ImmutableDockerExecutable.builder();
    }
}

