/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.docker.compose.execution;

import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;

public final class DockerForMacHostsIssue {
    private static final String REDIRECT_LINE = "127.0.0.1 localunixsocket\n";
    private static final String WARNING_MESSAGE = "\n\n **** WARNING: Your tests may be slow ****\nPlease add the following line to /etc/hosts:\n    127.0.0.1 localunixsocket\n\nFor more information, see https://github.com/docker/compose/issues/3419#issuecomment-221793401\n\n";
    private static volatile boolean checkPerformed = false;

    public static void issueWarning() {
        if (!checkPerformed && DockerForMacHostsIssue.onMacOsX() && !DockerForMacHostsIssue.localunixsocketRedirectedInEtcHosts()) {
            System.err.print(WARNING_MESSAGE);
        }
        checkPerformed = true;
    }

    private static boolean onMacOsX() {
        return System.getProperty("os.name", "generic").equals("Mac OS X");
    }

    private static boolean localunixsocketRedirectedInEtcHosts() {
        try {
            return Files.toString((File)new File("/etc/hosts"), (Charset)StandardCharsets.UTF_8).contains(REDIRECT_LINE);
        }
        catch (IOException e) {
            return true;
        }
    }

    public static void main(String[] _args) {
        DockerForMacHostsIssue.issueWarning();
    }

    private DockerForMacHostsIssue() {
    }
}

