/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.docker.compose.execution;

import com.palantir.docker.compose.connection.ContainerName;
import com.palantir.docker.compose.execution.DelegatingDockerCompose;
import com.palantir.docker.compose.execution.DockerCompose;
import com.palantir.docker.compose.execution.Retryer;
import java.io.IOException;
import java.util.List;

public final class RetryingDockerCompose
extends DelegatingDockerCompose {
    private final Retryer retryer;

    public RetryingDockerCompose(int retryAttempts, DockerCompose dockerCompose) {
        this(new Retryer(retryAttempts, Retryer.STANDARD_DELAY), dockerCompose);
    }

    public RetryingDockerCompose(Retryer retryer, DockerCompose dockerCompose) {
        super(dockerCompose);
        this.retryer = retryer;
    }

    @Override
    public void up() throws IOException, InterruptedException {
        this.retryer.runWithRetries(() -> {
            super.up();
            return null;
        });
    }

    @Override
    public List<ContainerName> ps() throws IOException, InterruptedException {
        return this.retryer.runWithRetries(() -> super.ps());
    }
}

