/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.docker.compose.logging;

import com.google.common.base.Preconditions;
import com.palantir.docker.compose.execution.DockerCompose;
import com.palantir.docker.compose.logging.LogCollector;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FileLogCollector
implements LogCollector {
    private static final Logger log = LoggerFactory.getLogger(FileLogCollector.class);
    private final File logDirectory;

    public FileLogCollector(File logDirectory) {
        Preconditions.checkArgument((!logDirectory.isFile() ? 1 : 0) != 0, (Object)"Log directory cannot be a file");
        if (!logDirectory.exists()) {
            Validate.isTrue((boolean)logDirectory.mkdirs(), (String)("Error making log directory: " + logDirectory.getAbsolutePath()), (Object[])new Object[0]);
        }
        this.logDirectory = logDirectory;
    }

    public static LogCollector fromPath(String path) {
        return new FileLogCollector(new File(path));
    }

    @Override
    public void collectLogs(DockerCompose dockerCompose) throws IOException, InterruptedException {
        for (String service : dockerCompose.services()) {
            try {
                this.collectLogs(service, dockerCompose);
            }
            catch (RuntimeException e) {
                log.error("Failed to collect logs for '{}'", (Object)service);
            }
        }
    }

    private void collectLogs(String container, DockerCompose dockerCompose) {
        File outputFile = new File(this.logDirectory, container + ".log");
        try {
            Files.createFile(outputFile.toPath(), new FileAttribute[0]);
        }
        catch (FileAlreadyExistsException fileAlreadyExistsException) {
        }
        catch (IOException e) {
            throw new RuntimeException("Error creating log file", e);
        }
        log.info("Writing logs for container '{}' to '{}'", (Object)container, (Object)outputFile.getAbsolutePath());
        try (FileOutputStream outputStream = new FileOutputStream(outputFile);){
            if (!dockerCompose.writeLogs(container, outputStream)) {
                log.error("Timed out while collecting logs for '{}'", (Object)container);
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Error reading log", e);
        }
    }
}

