/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.docker.compose.reporting;

import com.google.common.util.concurrent.Uninterruptibles;
import com.palantir.docker.compose.configuration.DockerComposeRuleConfig;
import com.palantir.docker.compose.reporting.HttpJsonPoster;
import com.palantir.docker.compose.reporting.ReportCompiler;
import com.palantir.docker.compose.reporting.ReportPoster;
import com.palantir.docker.compose.reporting.Reporter;
import com.palantir.docker.compose.reporting.ReportingConfig;
import java.time.Clock;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;

final class PostReportOnShutdown {
    private static final AtomicBoolean INSTALLED = new AtomicBoolean(false);
    private static final Reporter REPORTER = PostReportOnShutdown.createReporter();

    private static Reporter createReporter() {
        Optional<Reporter> possibleReportingConfig = DockerComposeRuleConfig.findAutomatically().flatMap(DockerComposeRuleConfig::reporting);
        return possibleReportingConfig.map(reportingConfig -> new ReportCompiler(Clock.systemUTC(), reportingConfig.envVarWhitelistPatterns(), new ReportPoster(new HttpJsonPoster((ReportingConfig)reportingConfig))::postReport)).orElse(Reporter.NoOpReporter.INSTANCE);
    }

    private PostReportOnShutdown() {
    }

    public static Reporter reporter() {
        PostReportOnShutdown.ensureInstalled();
        return REPORTER;
    }

    private static void ensureInstalled() {
        if (!INSTALLED.compareAndSet(false, true)) {
            return;
        }
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            REPORTER.report();
            Uninterruptibles.sleepUninterruptibly((long)300L, (TimeUnit)TimeUnit.MILLISECONDS);
        }));
    }
}

