/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.docker.compose.reporting;

import com.google.common.io.CharStreams;
import com.palantir.docker.compose.DockerComposeManager;
import com.palantir.docker.compose.report.DockerComposeRun;
import com.palantir.docker.compose.report.GitInfo;
import com.palantir.docker.compose.report.Report;
import com.palantir.docker.compose.report.Versions;
import com.palantir.docker.compose.reporting.ExceptionUtils;
import com.palantir.docker.compose.reporting.GitUtils;
import com.palantir.docker.compose.reporting.IdGenerator;
import com.palantir.docker.compose.reporting.PatternCollection;
import com.palantir.docker.compose.reporting.Reporter;
import com.palantir.logsafe.Arg;
import com.palantir.logsafe.SafeArg;
import com.palantir.logsafe.exceptions.SafeRuntimeException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.time.Clock;
import java.time.ZoneOffset;
import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import one.util.streamex.EntryStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class ReportCompiler
implements Reporter {
    private static final Logger log = LoggerFactory.getLogger(ReportCompiler.class);
    private static final String REPORT_API_VERSION = "2";
    private final Clock clock;
    private final PatternCollection environmentVariableWhitelist;
    private final Consumer<Report> reportConsumer;
    private final Report.Builder reportBuilder = Report.builder();

    ReportCompiler(Clock clock, PatternCollection environmentVariableWhitelist, Consumer<Report> reportConsumer) {
        this.clock = clock;
        this.environmentVariableWhitelist = environmentVariableWhitelist;
        this.reportConsumer = reportConsumer;
    }

    @Override
    public synchronized void addRun(DockerComposeRun dockerComposeRun) {
        this.reportBuilder.runs(dockerComposeRun);
    }

    @Override
    public synchronized void addException(Exception exception) {
        this.reportBuilder.exceptions(ExceptionUtils.exceptionToString(exception));
    }

    @Override
    public void report() {
        String reportId = IdGenerator.idFor("report");
        log.info("Reporting docker-compose run statistics with id {}", (Object)SafeArg.of((String)"reportId", (Object)reportId));
        this.reportConsumer.accept(this.reportBuilder.reportApiVersion(REPORT_API_VERSION).reportId(reportId).submittedTime(this.clock.instant().atOffset(ZoneOffset.UTC)).username(Optional.ofNullable(System.getProperty("user.name"))).gitInfo(this.gitInfo()).whitelistedEnvironmentVariables(this.whitelistedEnvironmentVariables()).versions(this.versions()).build());
    }

    private Versions versions() {
        return Versions.builder().dockerComposeRule(this.versionOf(DockerComposeManager.class)).docker(this.runProcess("docker", "--version")).dockerCompose(this.runProcess("docker-compose", "--version")).build();
    }

    private Optional<String> versionOf(Class<?> clazz) {
        return Optional.ofNullable(clazz.getPackage().getImplementationVersion());
    }

    private Map<String, String> whitelistedEnvironmentVariables() {
        return EntryStream.of(System.getenv()).filterKeys(this.environmentVariableWhitelist::anyMatch).toMap();
    }

    private GitInfo gitInfo() {
        return GitInfo.builder().branch(this.runProcess("git", "rev-parse", "--abbrev-ref", "HEAD")).commit(this.runProcess("git", "rev-parse", "HEAD")).dirty(this.runProcess("git", "status", "--short").map(output -> !output.isEmpty())).originPath(this.runProcess("git", "ls-remote", "--get-url", "origin").flatMap(GitUtils::parsePathFromGitRemoteUrl)).build();
    }

    private Optional<String> runProcess(String ... args) {
        try {
            Process process = new ProcessBuilder(new String[0]).command(args).start();
            boolean finished = process.waitFor(5L, TimeUnit.SECONDS);
            if (!finished) {
                process.destroyForcibly();
                throw new SafeRuntimeException("Command timed out", new Arg[0]);
            }
            if (process.exitValue() != 0) {
                throw new SafeRuntimeException("Process exited with non-zero exit code", new Arg[]{SafeArg.of((String)"exitValue", (Object)process.exitValue()), SafeArg.of((String)"stderr", (Object)this.inputStreamToString(process.getErrorStream()))});
            }
            return Optional.of(this.inputStreamToString(process.getInputStream()));
        }
        catch (IOException | InterruptedException | RuntimeException exception) {
            this.addException((Exception)new SafeRuntimeException("Running command failed.", (Throwable)exception, new Arg[]{SafeArg.of((String)"args", Arrays.asList(args))}));
            return Optional.empty();
        }
    }

    private String inputStreamToString(InputStream inputStream) throws IOException {
        return CharStreams.toString((Readable)new InputStreamReader(inputStream, StandardCharsets.UTF_8)).trim();
    }
}

