/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.docker.compose.reporting;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.palantir.conjure.java.serialization.ObjectMappers;
import com.palantir.docker.compose.report.Report;
import com.palantir.docker.compose.reporting.HttpJsonPoster;

class ReportPoster {
    private static final ObjectMapper OBJECT_MAPPER = ObjectMappers.newClientObjectMapper();
    private final HttpJsonPoster webhookPoster;

    ReportPoster(HttpJsonPoster webhookPoster) {
        this.webhookPoster = webhookPoster;
    }

    public void postReport(Report report) {
        this.webhookPoster.post(ReportPoster.toJson(report));
    }

    private static String toJson(Report report) {
        try {
            return OBJECT_MAPPER.writeValueAsString((Object)report);
        }
        catch (JsonProcessingException e) {
            throw new IllegalArgumentException(e);
        }
    }
}

