/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.docker.compose.reporting;

import com.palantir.docker.compose.events.Event;
import com.palantir.docker.compose.events.EventConsumer;
import com.palantir.docker.compose.report.DockerComposeRun;
import com.palantir.docker.compose.report.TestDescription;
import com.palantir.docker.compose.reporting.ExceptionUtils;
import com.palantir.docker.compose.reporting.IdGenerator;
import com.palantir.docker.compose.reporting.PostReportOnShutdown;
import com.palantir.docker.compose.reporting.Reporter;
import java.time.Clock;
import java.time.ZoneOffset;
import java.util.concurrent.Callable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RunRecorder
implements EventConsumer {
    private static final Logger log = LoggerFactory.getLogger(RunRecorder.class);
    private final Clock clock;
    private final Reporter reporter;
    private DockerComposeRun.Builder runBuilder;

    RunRecorder(Clock clock, Reporter reporter) {
        this.clock = clock;
        this.reporter = reporter;
        this.resetRunBuilder();
    }

    private void resetRunBuilder() {
        this.runBuilder = DockerComposeRun.builder().runId(IdGenerator.idFor("run")).testDescription(TestDescription.builder().build());
    }

    public void setDescription(TestDescription description) {
        this.runBuilder.testDescription(description);
    }

    public void before(Callable<String> dockerComposeConfig) {
        this.runBuilder.startTime(this.clock.instant().atOffset(ZoneOffset.UTC));
        try {
            this.runBuilder.dockerComposeConfig(dockerComposeConfig.call());
        }
        catch (Exception e) {
            this.runBuilder.exceptions(ExceptionUtils.exceptionToString(e));
            log.error("EnhancedDockerComposeRule has failed in before()", (Throwable)e);
        }
    }

    @Override
    public synchronized void receiveEvent(Event event) {
        this.runBuilder.events(event);
    }

    public void after() {
        try {
            this.runBuilder.finishTime(this.clock.instant().atOffset(ZoneOffset.UTC));
            this.reporter.addRun(this.runBuilder.build());
            this.resetRunBuilder();
        }
        catch (Exception e) {
            this.reporter.addException(e);
            log.error("EnhancedDockerComposeRule has failed in after()", (Throwable)e);
        }
    }

    public static RunRecorder defaults() {
        return new RunRecorder(Clock.systemUTC(), PostReportOnShutdown.reporter());
    }
}

