package com.palantir.docker.compose.report;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.palantir.conjure.java.lib.internal.ConjureCollections;
import com.palantir.docker.compose.events.Event;
import com.palantir.logsafe.Preconditions;
import com.palantir.logsafe.SafeArg;
import com.palantir.logsafe.exceptions.SafeIllegalArgumentException;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import javax.annotation.Nonnull;

/**
 * Data from a single lifetime (usually from an @Rule or @ClassRule) of a DockerComposeRule.
 */
@JsonDeserialize(builder = DockerComposeRun.Builder.class)
@Generated("com.palantir.conjure.java.types.BeanGenerator")
public final class DockerComposeRun {
    private final String runId;

    private final TestDescription testDescription;

    private final OffsetDateTime startTime;

    private final OffsetDateTime finishTime;

    private final List<Event> events;

    private final Optional<String> dockerComposeConfig;

    private final List<String> exceptions;

    private int memoizedHashCode;

    private DockerComposeRun(
            String runId,
            TestDescription testDescription,
            OffsetDateTime startTime,
            OffsetDateTime finishTime,
            List<Event> events,
            Optional<String> dockerComposeConfig,
            List<String> exceptions) {
        validateFields(runId, testDescription, startTime, finishTime, events, dockerComposeConfig, exceptions);
        this.runId = runId;
        this.testDescription = testDescription;
        this.startTime = startTime;
        this.finishTime = finishTime;
        this.events = Collections.unmodifiableList(events);
        this.dockerComposeConfig = dockerComposeConfig;
        this.exceptions = Collections.unmodifiableList(exceptions);
    }

    @JsonProperty("runId")
    public String getRunId() {
        return this.runId;
    }

    @JsonProperty("testDescription")
    public TestDescription getTestDescription() {
        return this.testDescription;
    }

    @JsonProperty("startTime")
    public OffsetDateTime getStartTime() {
        return this.startTime;
    }

    @JsonProperty("finishTime")
    public OffsetDateTime getFinishTime() {
        return this.finishTime;
    }

    @JsonProperty("events")
    public List<Event> getEvents() {
        return this.events;
    }

    @JsonProperty("dockerComposeConfig")
    public Optional<String> getDockerComposeConfig() {
        return this.dockerComposeConfig;
    }

    @JsonProperty("exceptions")
    public List<String> getExceptions() {
        return this.exceptions;
    }

    @Override
    public boolean equals(Object other) {
        return this == other || (other instanceof DockerComposeRun && equalTo((DockerComposeRun) other));
    }

    private boolean equalTo(DockerComposeRun other) {
        return this.runId.equals(other.runId)
                && this.testDescription.equals(other.testDescription)
                && this.startTime.isEqual(other.startTime)
                && this.finishTime.isEqual(other.finishTime)
                && this.events.equals(other.events)
                && this.dockerComposeConfig.equals(other.dockerComposeConfig)
                && this.exceptions.equals(other.exceptions);
    }

    @Override
    public int hashCode() {
        int result = memoizedHashCode;
        if (result == 0) {
            result = Objects.hash(
                    this.runId,
                    this.testDescription,
                    this.startTime.toInstant(),
                    this.finishTime.toInstant(),
                    this.events,
                    this.dockerComposeConfig,
                    this.exceptions);
            memoizedHashCode = result;
        }
        return result;
    }

    @Override
    public String toString() {
        return "DockerComposeRun{runId: " + runId + ", testDescription: " + testDescription + ", startTime: "
                + startTime + ", finishTime: " + finishTime + ", events: " + events + ", dockerComposeConfig: "
                + dockerComposeConfig + ", exceptions: " + exceptions + '}';
    }

    private static void validateFields(
            String runId,
            TestDescription testDescription,
            OffsetDateTime startTime,
            OffsetDateTime finishTime,
            List<Event> events,
            Optional<String> dockerComposeConfig,
            List<String> exceptions) {
        List<String> missingFields = null;
        missingFields = addFieldIfMissing(missingFields, runId, "runId");
        missingFields = addFieldIfMissing(missingFields, testDescription, "testDescription");
        missingFields = addFieldIfMissing(missingFields, startTime, "startTime");
        missingFields = addFieldIfMissing(missingFields, finishTime, "finishTime");
        missingFields = addFieldIfMissing(missingFields, events, "events");
        missingFields = addFieldIfMissing(missingFields, dockerComposeConfig, "dockerComposeConfig");
        missingFields = addFieldIfMissing(missingFields, exceptions, "exceptions");
        if (missingFields != null) {
            throw new SafeIllegalArgumentException(
                    "Some required fields have not been set", SafeArg.of("missingFields", missingFields));
        }
    }

    private static List<String> addFieldIfMissing(List<String> prev, Object fieldValue, String fieldName) {
        List<String> missingFields = prev;
        if (fieldValue == null) {
            if (missingFields == null) {
                missingFields = new ArrayList<>(7);
            }
            missingFields.add(fieldName);
        }
        return missingFields;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated("com.palantir.conjure.java.types.BeanBuilderGenerator")
    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder {
        private String runId;

        private TestDescription testDescription;

        private OffsetDateTime startTime;

        private OffsetDateTime finishTime;

        private List<Event> events = new ArrayList<>();

        private Optional<String> dockerComposeConfig = Optional.empty();

        private List<String> exceptions = new ArrayList<>();

        private Builder() {}

        public Builder from(DockerComposeRun other) {
            runId(other.getRunId());
            testDescription(other.getTestDescription());
            startTime(other.getStartTime());
            finishTime(other.getFinishTime());
            events(other.getEvents());
            dockerComposeConfig(other.getDockerComposeConfig());
            exceptions(other.getExceptions());
            return this;
        }

        @JsonSetter("runId")
        public Builder runId(@Nonnull String runId) {
            this.runId = Preconditions.checkNotNull(runId, "runId cannot be null");
            return this;
        }

        @JsonSetter("testDescription")
        public Builder testDescription(@Nonnull TestDescription testDescription) {
            this.testDescription = Preconditions.checkNotNull(testDescription, "testDescription cannot be null");
            return this;
        }

        @JsonSetter("startTime")
        public Builder startTime(@Nonnull OffsetDateTime startTime) {
            this.startTime = Preconditions.checkNotNull(startTime, "startTime cannot be null");
            return this;
        }

        @JsonSetter("finishTime")
        public Builder finishTime(@Nonnull OffsetDateTime finishTime) {
            this.finishTime = Preconditions.checkNotNull(finishTime, "finishTime cannot be null");
            return this;
        }

        @JsonSetter(value = "events", nulls = Nulls.SKIP)
        public Builder events(@Nonnull Iterable<Event> events) {
            this.events.clear();
            ConjureCollections.addAll(this.events, Preconditions.checkNotNull(events, "events cannot be null"));
            return this;
        }

        public Builder addAllEvents(@Nonnull Iterable<Event> events) {
            ConjureCollections.addAll(this.events, Preconditions.checkNotNull(events, "events cannot be null"));
            return this;
        }

        public Builder events(Event events) {
            this.events.add(events);
            return this;
        }

        @JsonSetter(value = "dockerComposeConfig", nulls = Nulls.SKIP)
        public Builder dockerComposeConfig(@Nonnull Optional<String> dockerComposeConfig) {
            this.dockerComposeConfig =
                    Preconditions.checkNotNull(dockerComposeConfig, "dockerComposeConfig cannot be null");
            return this;
        }

        public Builder dockerComposeConfig(@Nonnull String dockerComposeConfig) {
            this.dockerComposeConfig =
                    Optional.of(Preconditions.checkNotNull(dockerComposeConfig, "dockerComposeConfig cannot be null"));
            return this;
        }

        @JsonSetter(value = "exceptions", nulls = Nulls.SKIP)
        public Builder exceptions(@Nonnull Iterable<String> exceptions) {
            this.exceptions.clear();
            ConjureCollections.addAll(
                    this.exceptions, Preconditions.checkNotNull(exceptions, "exceptions cannot be null"));
            return this;
        }

        public Builder addAllExceptions(@Nonnull Iterable<String> exceptions) {
            ConjureCollections.addAll(
                    this.exceptions, Preconditions.checkNotNull(exceptions, "exceptions cannot be null"));
            return this;
        }

        public Builder exceptions(String exceptions) {
            this.exceptions.add(exceptions);
            return this;
        }

        public DockerComposeRun build() {
            return new DockerComposeRun(
                    runId, testDescription, startTime, finishTime, events, dockerComposeConfig, exceptions);
        }
    }
}
