/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.javaformat.java;

import com.google.errorprone.annotations.Immutable;

@Immutable
public final class JavaFormatterOptions {
    private final Style style;

    private JavaFormatterOptions(Style style) {
        this.style = style;
    }

    public int indentationMultiplier() {
        return this.style.indentationMultiplier();
    }

    public int maxLineLength() {
        return this.style.maxLineLength();
    }

    public Style style() {
        return this.style;
    }

    public static JavaFormatterOptions defaultOptions() {
        return JavaFormatterOptions.builder().build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Style style = Style.GOOGLE;

        private Builder() {
        }

        public Builder style(Style style) {
            this.style = style;
            return this;
        }

        public JavaFormatterOptions build() {
            return new JavaFormatterOptions(this.style);
        }
    }

    public static enum Style {
        PALANTIR(2, 120),
        GOOGLE(1, 100),
        AOSP(2, 100);

        private final int indentationMultiplier;
        private final int maxLineLength;

        private Style(int indentationMultiplier, int maxLineLength) {
            this.indentationMultiplier = indentationMultiplier;
            this.maxLineLength = maxLineLength;
        }

        int indentationMultiplier() {
            return this.indentationMultiplier;
        }

        public int maxLineLength() {
            return this.maxLineLength;
        }
    }
}

