/*
 * Decompiled with CFR 0.152.
 */
package com.paulhammant.ngwebdriver;

import com.paulhammant.ngwebdriver.ByAngularBinding;
import com.paulhammant.ngwebdriver.ByAngularButtonText;
import com.paulhammant.ngwebdriver.ByAngularCssContainingText;
import com.paulhammant.ngwebdriver.ByAngularExactBinding;
import com.paulhammant.ngwebdriver.ByAngularModel;
import com.paulhammant.ngwebdriver.ByAngularOptions;
import com.paulhammant.ngwebdriver.ByAngularPartialButtonText;
import com.paulhammant.ngwebdriver.ByAngularRepeater;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.openqa.selenium.By;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.SearchContext;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.remote.RemoteWebElement;

public class ByAngular {
    protected static final Map<String, String> functions = new HashMap<String, String>();

    private static void iterateOverJsFunctionsInSource(String src) {
        Pattern ps = Pattern.compile("^function.* \\{$", 8);
        Pattern pe = Pattern.compile("^\\}", 8);
        Matcher m = ps.matcher(src);
        boolean more = true;
        while (more && m.find()) {
            Matcher m2 = pe.matcher(src = src.substring(m.start()));
            if (m2.find()) {
                String body = src.substring(0, m2.start());
                ByAngular.storeJavaScriptFunction(body);
                src = src.substring(body.length());
                m = ps.matcher(src);
                continue;
            }
            more = false;
        }
    }

    private static void inlineUtilityFunctionsIfNeeded() {
        for (String functionName : functions.keySet()) {
            String functionBody = functions.get(functionName);
            if (!functionName.equals("repeaterMatch") && functionBody.indexOf("repeaterMatch") > 0) {
                functionBody = "var repeaterMatch = function(ngRepeat, repeater, exact) {" + functions.get("repeaterMatch") + "}\n" + functionBody;
            }
            if (!functionName.equals("getNg1Hooks") && functionBody.indexOf("getNg1Hooks") > 0) {
                functionBody = "var getNg1Hooks = function(selector, injectorPlease) {" + functions.get("getNg1Hooks") + "}\n" + functionBody;
            }
            functions.put(functionName, functionBody);
        }
    }

    private static void storeJavaScriptFunction(String body) {
        String fnName;
        Pattern regFn = Pattern.compile("^function ([a-zA-Z0-9]+)\\(", 8);
        Matcher m = regFn.matcher(body);
        if (m.find()) {
            fnName = m.group(1);
        } else {
            Pattern fnPro = Pattern.compile("^functions\\.([a-zA-Z0-9]+) ", 8);
            Matcher m2 = fnPro.matcher(body);
            if (m2.find()) {
                fnName = m2.group(1);
            } else {
                return;
            }
        }
        functions.put(fnName, body.substring(body.indexOf("{") + 1));
    }

    private ByAngular() {
    }

    public static Factory withRootSelector(String rootSelector) {
        return new Factory(rootSelector);
    }

    public static ByAngularRepeater repeater(String repeater) {
        return ByAngular.withRootSelector("[ng-app]").repeater(repeater);
    }

    public static ByAngularRepeater exactRepeater(String repeater) {
        return ByAngular.withRootSelector("[ng-app]").exactRepeater(repeater);
    }

    public static ByAngularBinding binding(String binding) {
        return ByAngular.withRootSelector("[ng-app]").binding(binding);
    }

    public static ByAngularExactBinding exactBinding(String exactBinding) {
        return ByAngular.withRootSelector("[ng-app]").exactBinding(exactBinding);
    }

    public static ByAngularModel model(String model) {
        return ByAngular.withRootSelector("[ng-app]").model(model);
    }

    public static ByAngularOptions options(String options) {
        return ByAngular.withRootSelector("[ng-app]").options(options);
    }

    public static ByAngularButtonText buttonText(String buttonText) {
        return ByAngular.withRootSelector("[ng-app]").buttonText(buttonText);
    }

    public static ByAngularPartialButtonText partialButtonText(String partialButtonText) {
        return ByAngular.withRootSelector("[ng-app]").partialButtonText(partialButtonText);
    }

    public static ByAngularCssContainingText cssContainingText(String cssSelector, String searchText) {
        return ByAngular.withRootSelector("[ng-app]").cssContainingText(cssSelector, searchText);
    }

    static {
        InputStream resourceAsStream = ByAngular.class.getResourceAsStream("/js/clientsidescripts.js");
        if (resourceAsStream == null) {
            try {
                resourceAsStream = new FileInputStream(new File("src/main/resources/js/clientsidescripts.js"));
            }
            catch (FileNotFoundException e) {
                throw new RuntimeException("Could not find clientsidescripts.js in file system or in jar", e);
            }
        }
        String src = new Scanner(resourceAsStream, "UTF-8").useDelimiter("\\A").next();
        ByAngular.iterateOverJsFunctionsInSource(src);
        ByAngular.inlineUtilityFunctionsIfNeeded();
    }

    public static class Factory {
        private String rootSelector;

        Factory(String rootSelector) {
            this.rootSelector = rootSelector;
        }

        public ByAngularRepeater repeater(String repeater) {
            return new ByAngularRepeater(this.rootSelector, repeater, false);
        }

        public ByAngularRepeater exactRepeater(String repeater) {
            return new ByAngularRepeater(this.rootSelector, repeater, true);
        }

        public ByAngularBinding binding(String binding) {
            return new ByAngularBinding(this.rootSelector, binding);
        }

        public ByAngularExactBinding exactBinding(String exactBinding) {
            return new ByAngularExactBinding(this.rootSelector, exactBinding);
        }

        public ByAngularModel model(String model) {
            return new ByAngularModel(this.rootSelector, model);
        }

        public ByAngularOptions options(String options) {
            return new ByAngularOptions(this.rootSelector, options);
        }

        public ByAngularButtonText buttonText(String buttonText) {
            return new ByAngularButtonText(this.rootSelector, buttonText);
        }

        public ByAngularPartialButtonText partialButtonText(String partialButtonText) {
            return new ByAngularPartialButtonText(this.rootSelector, partialButtonText);
        }

        public ByAngularCssContainingText cssContainingText(String cssSelector, String searchText) {
            return new ByAngularCssContainingText(this.rootSelector, cssSelector, searchText);
        }
    }

    public static abstract class BaseBy
    extends By {
        protected final String rootSelector;

        protected BaseBy(String rootSelector) {
            this.rootSelector = rootSelector;
        }

        private final JavascriptExecutor getJavascriptExecutor(SearchContext context) {
            JavascriptExecutor jse = context instanceof RemoteWebElement ? (JavascriptExecutor)((RemoteWebElement)context).getWrappedDriver() : (JavascriptExecutor)context;
            return jse;
        }

        protected final Object errorIfNull(Object o) {
            if (o == null || o instanceof List && ((List)o).size() == 0) {
                throw new NoSuchElementException((Object)((Object)this) + " didn't have any matching elements at this place in the DOM");
            }
            return o;
        }

        public WebElement findElement(SearchContext context) {
            JavascriptExecutor javascriptExecutor = this.getJavascriptExecutor(context);
            if (context instanceof WebDriver) {
                context = null;
            }
            return (WebElement)((List)this.errorIfNull(this.getObject(context, javascriptExecutor))).get(0);
        }

        protected abstract Object getObject(SearchContext var1, JavascriptExecutor var2);

        public List<WebElement> findElements(SearchContext context) {
            JavascriptExecutor javascriptExecutor = this.getJavascriptExecutor(context);
            if (context instanceof WebDriver) {
                context = null;
            }
            return (List)this.errorIfNull(this.getObject(context, javascriptExecutor));
        }
    }
}

