/*
 * Decompiled with CFR 0.152.
 */
package com.pinterest.ktlint.rule.engine.api;

import com.pinterest.ktlint.rule.engine.core.api.RuleId;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0010\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0013\u0010\u0016\u001a\u00020\n2\b\u0010\u0017\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\u0018\u001a\u00020\u0003H\u0016J\b\u0010\u0019\u001a\u00020\bH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000eR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006\u001a"}, d2={"Lcom/pinterest/ktlint/rule/engine/api/LintError;", "", "line", "", "col", "ruleId", "Lcom/pinterest/ktlint/rule/engine/core/api/RuleId;", "detail", "", "canBeAutoCorrected", "", "<init>", "(IILcom/pinterest/ktlint/rule/engine/core/api/RuleId;Ljava/lang/String;Z)V", "getLine", "()I", "getCol", "getRuleId", "()Lcom/pinterest/ktlint/rule/engine/core/api/RuleId;", "getDetail", "()Ljava/lang/String;", "getCanBeAutoCorrected", "()Z", "equals", "other", "hashCode", "toString", "ktlint-rule-engine"})
public final class LintError {
    private final int line;
    private final int col;
    @NotNull
    private final RuleId ruleId;
    @NotNull
    private final String detail;
    private final boolean canBeAutoCorrected;

    public LintError(int line, int col, @NotNull RuleId ruleId, @NotNull String detail, boolean canBeAutoCorrected) {
        Intrinsics.checkNotNullParameter((Object)ruleId, (String)"ruleId");
        Intrinsics.checkNotNullParameter((Object)detail, (String)"detail");
        this.line = line;
        this.col = col;
        this.ruleId = ruleId;
        this.detail = detail;
        this.canBeAutoCorrected = canBeAutoCorrected;
    }

    public final int getLine() {
        return this.line;
    }

    public final int getCol() {
        return this.col;
    }

    @NotNull
    public final RuleId getRuleId() {
        return this.ruleId;
    }

    @NotNull
    public final String getDetail() {
        return this.detail;
    }

    public final boolean getCanBeAutoCorrected() {
        return this.canBeAutoCorrected;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof LintError)) {
            return false;
        }
        LintError lintError = (LintError)other;
        if (this.line != lintError.line) {
            return false;
        }
        if (this.col != lintError.col) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.ruleId, (Object)lintError.ruleId)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.detail, (Object)lintError.detail)) {
            return false;
        }
        return this.canBeAutoCorrected == lintError.canBeAutoCorrected;
    }

    public int hashCode() {
        int result = this.line;
        result = result * 31 + this.col;
        result = result * 31 + this.ruleId.hashCode();
        result = result * 31 + this.detail.hashCode();
        result = result * 31 + Boolean.hashCode(this.canBeAutoCorrected);
        return result;
    }

    @NotNull
    public String toString() {
        return "LintError(line=" + this.line + ", col=" + this.col + ", ruleId=" + this.ruleId + ", detail=" + this.detail + ", canBeAutoCorrected=" + this.canBeAutoCorrected + ')';
    }
}

