/*
 * Decompiled with CFR 0.152.
 */
package com.pinterest.ktlint.ruleset.standard.rules;

import com.pinterest.ktlint.rule.engine.core.api.ASTNodeExtensionKt;
import com.pinterest.ktlint.rule.engine.core.api.ElementType;
import com.pinterest.ktlint.rule.engine.core.api.SinceKtlint;
import com.pinterest.ktlint.ruleset.standard.StandardRule;
import com.pinterest.ktlint.ruleset.standard.rules.PropertyNamingRule;
import com.pinterest.ktlint.ruleset.standard.rules.internal.RegExIgnoringDiacriticsAndStrokesOnLettersKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.lang.ASTNode;
import org.jetbrains.kotlin.com.intellij.psi.tree.IElementType;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0007\u0018\u0000 \"2\u00020\u0001:\u0001\"B\u0005\u00a2\u0006\u0002\u0010\u0002Je\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2K\u0010\t\u001aG\u0012\u0013\u0012\u00110\u000b\u00a2\u0006\f\b\f\u0012\b\b\r\u0012\u0004\b\b(\u000e\u0012\u0013\u0012\u00110\u000f\u00a2\u0006\f\b\f\u0012\b\b\r\u0012\u0004\b\b(\u0010\u0012\u0013\u0012\u00110\b\u00a2\u0006\f\b\f\u0012\b\b\r\u0012\u0004\b\b(\u0011\u0012\u0004\u0012\u00020\u00040\nH\u0016J]\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\u00062K\u0010\t\u001aG\u0012\u0013\u0012\u00110\u000b\u00a2\u0006\f\b\f\u0012\b\b\r\u0012\u0004\b\b(\u000e\u0012\u0013\u0012\u00110\u000f\u00a2\u0006\f\b\f\u0012\b\b\r\u0012\u0004\b\b(\u0010\u0012\u0013\u0012\u00110\b\u00a2\u0006\f\b\f\u0012\b\b\r\u0012\u0004\b\b(\u0011\u0012\u0004\u0012\u00020\u00040\nH\u0002J]\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\u00062K\u0010\t\u001aG\u0012\u0013\u0012\u00110\u000b\u00a2\u0006\f\b\f\u0012\b\b\r\u0012\u0004\b\b(\u000e\u0012\u0013\u0012\u00110\u000f\u00a2\u0006\f\b\f\u0012\b\b\r\u0012\u0004\b\b(\u0010\u0012\u0013\u0012\u00110\b\u00a2\u0006\f\b\f\u0012\b\b\r\u0012\u0004\b\b(\u0011\u0012\u0004\u0012\u00020\u00040\nH\u0002J]\u0010\u0015\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\u00062K\u0010\t\u001aG\u0012\u0013\u0012\u00110\u000b\u00a2\u0006\f\b\f\u0012\b\b\r\u0012\u0004\b\b(\u000e\u0012\u0013\u0012\u00110\u000f\u00a2\u0006\f\b\f\u0012\b\b\r\u0012\u0004\b\b(\u0010\u0012\u0013\u0012\u00110\b\u00a2\u0006\f\b\f\u0012\b\b\r\u0012\u0004\b\b(\u0011\u0012\u0004\u0012\u00020\u00040\nH\u0002J]\u0010\u0016\u001a\u00020\u00042\u0006\u0010\u0017\u001a\u00020\u00062K\u0010\t\u001aG\u0012\u0013\u0012\u00110\u000b\u00a2\u0006\f\b\f\u0012\b\b\r\u0012\u0004\b\b(\u000e\u0012\u0013\u0012\u00110\u000f\u00a2\u0006\f\b\f\u0012\b\b\r\u0012\u0004\b\b(\u0010\u0012\u0013\u0012\u00110\b\u00a2\u0006\f\b\f\u0012\b\b\r\u0012\u0004\b\b(\u0011\u0012\u0004\u0012\u00020\u00040\nH\u0002J\f\u0010\u0018\u001a\u00020\b*\u00020\u0006H\u0002J\f\u0010\u0019\u001a\u00020\b*\u00020\u0006H\u0002J\f\u0010\u001a\u001a\u00020\b*\u00020\u0006H\u0002J\u0014\u0010\u001b\u001a\u00020\b*\u00020\u00062\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u0014\u0010\u001e\u001a\u00020\b*\u00020\u00062\u0006\u0010\u0013\u001a\u00020\u000fH\u0002J\f\u0010\u001f\u001a\u00020\b*\u00020\u0006H\u0002J\f\u0010 \u001a\u00020\b*\u00020\u0006H\u0002J\f\u0010!\u001a\u00020\b*\u00020\u0006H\u0002\u00a8\u0006#"}, d2={"Lcom/pinterest/ktlint/ruleset/standard/rules/PropertyNamingRule;", "Lcom/pinterest/ktlint/ruleset/standard/StandardRule;", "()V", "beforeVisitChildNodes", "", "node", "Lorg/jetbrains/kotlin/com/intellij/lang/ASTNode;", "autoCorrect", "", "emit", "Lkotlin/Function3;", "", "Lkotlin/ParameterName;", "name", "offset", "", "errorMessage", "canBeAutoCorrected", "visitBackingProperty", "identifier", "visitConstProperty", "visitNonConstProperty", "visitProperty", "property", "containsValKeyword", "hasConstModifier", "hasCustomGetter", "hasModifier", "iElementType", "Lorg/jetbrains/kotlin/com/intellij/psi/tree/IElementType;", "hasPublicProperty", "isBackingProperty", "isObjectValue", "isTopLevelValue", "Companion", "ktlint-ruleset-standard"})
@SinceKtlint.Container(value={@SinceKtlint(version="0.48", status=SinceKtlint.Status.EXPERIMENTAL), @SinceKtlint(version="1.0", status=SinceKtlint.Status.STABLE)})
@SourceDebugExtension(value={"SMAP\nPropertyNamingRule.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PropertyNamingRule.kt\ncom/pinterest/ktlint/ruleset/standard/rules/PropertyNamingRule\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,157:1\n1#2:158\n1247#3,2:159\n1247#3,2:161\n1247#3,2:163\n*S KotlinDebug\n*F\n+ 1 PropertyNamingRule.kt\ncom/pinterest/ktlint/ruleset/standard/rules/PropertyNamingRule\n*L\n120#1:159,2\n124#1:161,2\n146#1:163,2\n*E\n"})
public final class PropertyNamingRule
extends StandardRule {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private static final Regex LOWER_CAMEL_CASE_REGEXP = RegExIgnoringDiacriticsAndStrokesOnLettersKt.regExIgnoringDiacriticsAndStrokesOnLetters("[a-z][a-zA-Z0-9]*");
    @NotNull
    private static final Regex SCREAMING_SNAKE_CASE_REGEXP = RegExIgnoringDiacriticsAndStrokesOnLettersKt.regExIgnoringDiacriticsAndStrokesOnLetters("[A-Z][_A-Z0-9]*");
    @NotNull
    private static final Regex BACKING_PROPERTY_LOWER_CAMEL_CASE_REGEXP = RegExIgnoringDiacriticsAndStrokesOnLettersKt.regExIgnoringDiacriticsAndStrokesOnLetters("_[a-z][a-zA-Z0-9]*");
    @Deprecated
    @NotNull
    public static final String SERIAL_VERSION_UID_PROPERTY_NAME = "serialVersionUID";

    public PropertyNamingRule() {
        super("property-naming", null, null, 6, null);
    }

    public void beforeVisitChildNodes(@NotNull ASTNode node, boolean autoCorrect, @NotNull Function3<? super Integer, ? super String, ? super Boolean, Unit> emit) {
        block0: {
            ASTNode aSTNode;
            ASTNode aSTNode2;
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            Intrinsics.checkNotNullParameter(emit, (String)"emit");
            ASTNode it = aSTNode2 = node;
            boolean bl = false;
            Object object = aSTNode = Intrinsics.areEqual((Object)node.getElementType(), (Object)ElementType.INSTANCE.getPROPERTY()) ? aSTNode2 : null;
            if (aSTNode == null) break block0;
            ASTNode property = aSTNode;
            boolean bl2 = false;
            this.visitProperty(property, emit);
        }
    }

    private final void visitProperty(ASTNode property, Function3<? super Integer, ? super String, ? super Boolean, Unit> emit) {
        block2: {
            ASTNode identifier;
            block3: {
                ASTNode aSTNode = property.findChildByType(ElementType.INSTANCE.getIDENTIFIER());
                if (aSTNode == null) break block2;
                identifier = aSTNode;
                boolean bl = false;
                if (!this.hasConstModifier(property)) break block3;
                this.visitConstProperty(identifier, emit);
                break block2;
            }
            if (this.hasCustomGetter(property) || this.isTopLevelValue(property) || this.isObjectValue(property)) break block2;
            if (this.isBackingProperty(property)) {
                this.visitBackingProperty(identifier, emit);
            } else {
                this.visitNonConstProperty(identifier, emit);
            }
        }
    }

    private final void visitBackingProperty(ASTNode identifier, Function3<? super Integer, ? super String, ? super Boolean, Unit> emit) {
        block0: {
            String string;
            String string2;
            String it = string2 = identifier.getText();
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it);
            String string3 = string = !BACKING_PROPERTY_LOWER_CAMEL_CASE_REGEXP.matches((CharSequence)it) ? string2 : null;
            if (string == null) break block0;
            it = string;
            boolean bl2 = false;
            emit.invoke((Object)identifier.getStartOffset(), (Object)"Backing property name should start with underscore followed by lower camel case", (Object)false);
        }
    }

    private final void visitConstProperty(ASTNode identifier, Function3<? super Integer, ? super String, ? super Boolean, Unit> emit) {
        block1: {
            String string;
            String string2;
            String string3;
            String it = string3 = identifier.getText();
            boolean bl = false;
            String string4 = string2 = !Intrinsics.areEqual((Object)it, (Object)SERIAL_VERSION_UID_PROPERTY_NAME) ? string3 : null;
            if (string2 == null) break block1;
            String it2 = string = string2;
            boolean bl2 = false;
            String string5 = string3 = !SCREAMING_SNAKE_CASE_REGEXP.matches((CharSequence)it2) ? string : null;
            if (string3 != null) {
                it2 = string3;
                boolean bl3 = false;
                emit.invoke((Object)identifier.getStartOffset(), (Object)"Property name should use the screaming snake case notation when the value can not be changed", (Object)false);
            }
        }
    }

    private final void visitNonConstProperty(ASTNode identifier, Function3<? super Integer, ? super String, ? super Boolean, Unit> emit) {
        block0: {
            String string;
            String string2;
            String it = string2 = identifier.getText();
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it);
            String string3 = string = !LOWER_CAMEL_CASE_REGEXP.matches((CharSequence)it) ? string2 : null;
            if (string == null) break block0;
            it = string;
            boolean bl2 = false;
            emit.invoke((Object)identifier.getStartOffset(), (Object)"Property name should start with a lowercase letter and use camel case", (Object)false);
        }
    }

    private final boolean hasCustomGetter(ASTNode $this$hasCustomGetter) {
        ASTNode aSTNode = $this$hasCustomGetter.findChildByType(ElementType.INSTANCE.getPROPERTY_ACCESSOR());
        return (aSTNode != null ? aSTNode.findChildByType(ElementType.INSTANCE.getGET_KEYWORD()) : null) != null;
    }

    private final boolean hasConstModifier(ASTNode $this$hasConstModifier) {
        return this.hasModifier($this$hasConstModifier, ElementType.INSTANCE.getCONST_KEYWORD());
    }

    private final boolean hasModifier(ASTNode $this$hasModifier, IElementType iElementType) {
        boolean bl;
        block2: {
            ASTNode aSTNode = $this$hasModifier.findChildByType(ElementType.INSTANCE.getMODIFIER_LIST());
            Sequence sequence = aSTNode != null ? ASTNodeExtensionKt.children((ASTNode)aSTNode) : null;
            if (sequence == null) {
                sequence = SequencesKt.emptySequence();
            }
            Sequence $this$any$iv = sequence;
            boolean $i$f$any = false;
            for (Object element$iv : $this$any$iv) {
                ASTNode it = (ASTNode)element$iv;
                boolean bl2 = false;
                if (!Intrinsics.areEqual((Object)it.getElementType(), (Object)iElementType)) continue;
                bl = true;
                break block2;
            }
            bl = false;
        }
        return bl;
    }

    private final boolean isTopLevelValue(ASTNode $this$isTopLevelValue) {
        return Intrinsics.areEqual((Object)$this$isTopLevelValue.getTreeParent().getElementType(), (Object)ElementType.INSTANCE.getFILE()) && this.containsValKeyword($this$isTopLevelValue);
    }

    private final boolean containsValKeyword(ASTNode $this$containsValKeyword) {
        boolean bl;
        block1: {
            Sequence $this$any$iv = ASTNodeExtensionKt.children((ASTNode)$this$containsValKeyword);
            boolean $i$f$any = false;
            for (Object element$iv : $this$any$iv) {
                ASTNode it = (ASTNode)element$iv;
                boolean bl2 = false;
                if (!Intrinsics.areEqual((Object)it.getElementType(), (Object)ElementType.INSTANCE.getVAL_KEYWORD())) continue;
                bl = true;
                break block1;
            }
            bl = false;
        }
        return bl;
    }

    private final boolean isObjectValue(ASTNode $this$isObjectValue) {
        ASTNode aSTNode;
        return Intrinsics.areEqual((Object)$this$isObjectValue.getTreeParent().getElementType(), (Object)ElementType.INSTANCE.getCLASS_BODY()) && Intrinsics.areEqual((Object)((aSTNode = $this$isObjectValue.getTreeParent()) != null && (aSTNode = aSTNode.getTreeParent()) != null ? aSTNode.getElementType() : null), (Object)ElementType.INSTANCE.getOBJECT_DECLARATION()) && this.containsValKeyword($this$isObjectValue) && !this.hasModifier($this$isObjectValue, ElementType.INSTANCE.getOVERRIDE_KEYWORD());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isBackingProperty(ASTNode $this$isBackingProperty) {
        ASTNode aSTNode;
        ASTNode aSTNode2;
        ASTNode it = aSTNode2 = $this$isBackingProperty;
        boolean bl = false;
        if (!this.hasModifier($this$isBackingProperty, ElementType.INSTANCE.getPRIVATE_KEYWORD())) return false;
        ASTNode aSTNode3 = aSTNode2;
        ASTNode aSTNode4 = aSTNode3;
        if (aSTNode4 == null) return false;
        aSTNode2 = aSTNode4.findChildByType(ElementType.INSTANCE.getIDENTIFIER());
        if (aSTNode2 == null) return false;
        ASTNode it2 = aSTNode = aSTNode2;
        boolean bl2 = false;
        String string = it2.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        if (!StringsKt.startsWith$default((String)string, (String)"_", (boolean)false, (int)2, null)) return false;
        ASTNode aSTNode5 = aSTNode;
        ASTNode aSTNode6 = aSTNode5;
        if (aSTNode6 == null) return false;
        ASTNode identifier = aSTNode6;
        boolean bl3 = false;
        String string2 = identifier.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getText(...)");
        boolean bl4 = this.hasPublicProperty($this$isBackingProperty, StringsKt.removePrefix((String)string2, (CharSequence)"_"));
        return bl4;
    }

    private final boolean hasPublicProperty(ASTNode $this$hasPublicProperty, String identifier) {
        boolean bl;
        block1: {
            ASTNode aSTNode = $this$hasPublicProperty.getTreeParent();
            Intrinsics.checkNotNullExpressionValue((Object)aSTNode, (String)"getTreeParent(...)");
            Sequence $this$any$iv = SequencesKt.mapNotNull((Sequence)SequencesKt.filter((Sequence)ASTNodeExtensionKt.children((ASTNode)aSTNode), (Function1)hasPublicProperty.1.INSTANCE), (Function1)hasPublicProperty.2.INSTANCE);
            boolean $i$f$any = false;
            for (Object element$iv : $this$any$iv) {
                ASTNode it = (ASTNode)element$iv;
                boolean bl2 = false;
                if (!Intrinsics.areEqual((Object)it.getText(), (Object)identifier)) continue;
                bl = true;
                break block1;
            }
            bl = false;
        }
        return bl;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006R\u0011\u0010\t\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0006R\u000e\u0010\u000b\u001a\u00020\fX\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/pinterest/ktlint/ruleset/standard/rules/PropertyNamingRule$Companion;", "", "()V", "BACKING_PROPERTY_LOWER_CAMEL_CASE_REGEXP", "Lkotlin/text/Regex;", "getBACKING_PROPERTY_LOWER_CAMEL_CASE_REGEXP", "()Lkotlin/text/Regex;", "LOWER_CAMEL_CASE_REGEXP", "getLOWER_CAMEL_CASE_REGEXP", "SCREAMING_SNAKE_CASE_REGEXP", "getSCREAMING_SNAKE_CASE_REGEXP", "SERIAL_VERSION_UID_PROPERTY_NAME", "", "ktlint-ruleset-standard"})
    private static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Regex getLOWER_CAMEL_CASE_REGEXP() {
            return LOWER_CAMEL_CASE_REGEXP;
        }

        @NotNull
        public final Regex getSCREAMING_SNAKE_CASE_REGEXP() {
            return SCREAMING_SNAKE_CASE_REGEXP;
        }

        @NotNull
        public final Regex getBACKING_PROPERTY_LOWER_CAMEL_CASE_REGEXP() {
            return BACKING_PROPERTY_LOWER_CAMEL_CASE_REGEXP;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

