/*
 * Decompiled with CFR 0.152.
 */
package com.pinterest.ktlint.ruleset.standard.rules;

import com.pinterest.ktlint.rule.engine.core.api.ASTNodeExtensionKt;
import com.pinterest.ktlint.rule.engine.core.api.AutocorrectDecision;
import com.pinterest.ktlint.rule.engine.core.api.ElementType;
import com.pinterest.ktlint.rule.engine.core.api.SinceKtlint;
import com.pinterest.ktlint.ruleset.standard.StandardRule;
import com.pinterest.ktlint.ruleset.standard.rules.internal.RegExIgnoringDiacriticsAndStrokesOnLettersKt;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.lang.ASTNode;
import org.jetbrains.kotlin.com.intellij.lang.FileASTNode;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.tree.IElementType;
import org.jetbrains.kotlin.psi.KtFile;

@SinceKtlint(version="0.23", status=SinceKtlint.Status.STABLE)
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000e\b\u0007\u0018\u0000 $2\u00020\u0001:\u0002#$B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J]\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072K\u0010\b\u001aG\u0012\u0013\u0012\u00110\n\u00a2\u0006\f\b\u000b\u0012\b\b\f\u0012\u0004\b\b(\r\u0012\u0013\u0012\u00110\u000e\u00a2\u0006\f\b\u000b\u0012\b\b\f\u0012\u0004\b\b(\u000f\u0012\u0013\u0012\u00110\u0010\u00a2\u0006\f\b\u000b\u0012\b\b\f\u0012\u0004\b\b(\u0011\u0012\u0004\u0012\u00020\u00120\tH\u0016J\u001e\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014*\u00020\u00072\n\b\u0002\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0002J\f\u0010\u0018\u001a\u00020\u0010*\u00020\u0007H\u0002J\u0014\u0010\u0019\u001a\u00020\u0010*\u00020\u00072\u0006\u0010\u001a\u001a\u00020\u000eH\u0002J\f\u0010\u001b\u001a\u00020\u0010*\u00020\u0007H\u0002J\u0014\u0010\u001c\u001a\u00020\u0010*\u00020\u00072\u0006\u0010\u001a\u001a\u00020\u000eH\u0002Ja\u0010\u001d\u001a\u00020\u0005*\u00020\u000e2\u0006\u0010\u001a\u001a\u00020\u000e2K\u0010\b\u001aG\u0012\u0013\u0012\u00110\n\u00a2\u0006\f\b\u000b\u0012\b\b\f\u0012\u0004\b\b(\r\u0012\u0013\u0012\u00110\u000e\u00a2\u0006\f\b\u000b\u0012\b\b\f\u0012\u0004\b\b(\u000f\u0012\u0013\u0012\u00110\u0010\u00a2\u0006\f\b\u000b\u0012\b\b\f\u0012\u0004\b\b(\u0011\u0012\u0004\u0012\u00020\u00120\tH\u0002J\f\u0010\u001e\u001a\u00020\u000e*\u00020\u000eH\u0002Ja\u0010\u001f\u001a\u00020\u0005*\u00020\u000e2\u0006\u0010 \u001a\u00020\u000e2K\u0010\b\u001aG\u0012\u0013\u0012\u00110\n\u00a2\u0006\f\b\u000b\u0012\b\b\f\u0012\u0004\b\b(\r\u0012\u0013\u0012\u00110\u000e\u00a2\u0006\f\b\u000b\u0012\b\b\f\u0012\u0004\b\b(\u000f\u0012\u0013\u0012\u00110\u0010\u00a2\u0006\f\b\u000b\u0012\b\b\f\u0012\u0004\b\b(\u0011\u0012\u0004\u0012\u00020\u00120\tH\u0002JY\u0010!\u001a\u00020\u0005*\u00020\u000e2K\u0010\b\u001aG\u0012\u0013\u0012\u00110\n\u00a2\u0006\f\b\u000b\u0012\b\b\f\u0012\u0004\b\b(\r\u0012\u0013\u0012\u00110\u000e\u00a2\u0006\f\b\u000b\u0012\b\b\f\u0012\u0004\b\b(\u000f\u0012\u0013\u0012\u00110\u0010\u00a2\u0006\f\b\u000b\u0012\b\b\f\u0012\u0004\b\b(\u0011\u0012\u0004\u0012\u00020\u00120\tH\u0002J\u000e\u0010\"\u001a\u0004\u0018\u00010\u0015*\u00020\u0007H\u0002\u00a8\u0006%"}, d2={"Lcom/pinterest/ktlint/ruleset/standard/rules/FilenameRule;", "Lcom/pinterest/ktlint/ruleset/standard/StandardRule;", "<init>", "()V", "beforeVisitChildNodes", "", "node", "Lorg/jetbrains/kotlin/com/intellij/lang/ASTNode;", "emit", "Lkotlin/Function3;", "", "Lkotlin/ParameterName;", "name", "offset", "", "errorMessage", "", "canBeAutoCorrected", "Lcom/pinterest/ktlint/rule/engine/core/api/AutocorrectDecision;", "topLevelDeclarations", "", "Lcom/pinterest/ktlint/ruleset/standard/rules/FilenameRule$TopLevelDeclaration;", "elementType", "Lorg/jetbrains/kotlin/com/intellij/psi/tree/IElementType;", "doesNotHavePrivateModifier", "hasTopLevelDeclarationNotExtending", "className", "isNotClassRelatedTopLevelDeclaration", "isFunctionNotExtending", "shouldMatchClassName", "toPascalCase", "shouldMatchFileName", "filename", "shouldMatchPascalCase", "toTopLevelDeclaration", "TopLevelDeclaration", "Companion", "ktlint-ruleset-standard"})
@SourceDebugExtension(value={"SMAP\nFilenameRule.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FilenameRule.kt\ncom/pinterest/ktlint/ruleset/standard/rules/FilenameRule\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,181:1\n2275#2,2:182\n1255#2,2:184\n1#3:186\n*S KotlinDebug\n*F\n+ 1 FilenameRule.kt\ncom/pinterest/ktlint/ruleset/standard/rules/FilenameRule\n*L\n112#1:182,2\n118#1:184,2\n*E\n"})
public final class FilenameRule
extends StandardRule {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private static final Regex PASCAL_CASE_REGEX = RegExIgnoringDiacriticsAndStrokesOnLettersKt.regExIgnoringDiacriticsAndStrokesOnLetters("^[A-Z][A-Za-z\\d]*$");
    @NotNull
    private static final List<IElementType> NON_CLASS_RELATED_TOP_LEVEL_DECLARATION_TYPES;

    public FilenameRule() {
        super("filename", null, null, 6, null);
    }

    @Override
    public void beforeVisitChildNodes(@NotNull ASTNode node, @NotNull Function3<? super Integer, ? super String, ? super Boolean, ? extends AutocorrectDecision> emit) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter(emit, (String)"emit");
        if (ASTNodeExtensionKt.isRoot20((ASTNode)node)) {
            String filePath;
            FileASTNode cfr_ignored_0 = (FileASTNode)node;
            PsiElement psiElement = ((FileASTNode)node).getPsi();
            KtFile ktFile = psiElement instanceof KtFile ? (KtFile)psiElement : null;
            String string = filePath = ktFile != null ? ktFile.getVirtualFilePath() : null;
            if (!(string != null ? StringsKt.endsWith$default((String)string, (String)".kt", (boolean)false, (int)2, null) : false) || StringsKt.endsWith$default((String)filePath, (String)"package.kt", (boolean)false, (int)2, null)) {
                this.stopTraversalOfAST();
                return;
            }
            String fileName = StringsKt.substringBefore$default((String)StringsKt.substringAfterLast$default((String)StringsKt.replace$default((String)filePath, (char)'\\', (char)'/', (boolean)false, (int)4, null), (String)"/", null, (int)2, null), (String)".", null, (int)2, null);
            List<TopLevelDeclaration> topLevelClassDeclarations = this.topLevelDeclarations(node, ElementType.INSTANCE.getCLASS());
            if (topLevelClassDeclarations.size() == 1) {
                TopLevelDeclaration topLevelClassDeclaration = (TopLevelDeclaration)CollectionsKt.first(topLevelClassDeclarations);
                if (this.hasTopLevelDeclarationNotExtending(node, topLevelClassDeclaration.getIdentifier())) {
                    this.shouldMatchPascalCase(fileName, emit);
                } else {
                    this.shouldMatchClassName(fileName, topLevelClassDeclaration.getIdentifier(), emit);
                }
            } else {
                List topLevelDeclarations = FilenameRule.topLevelDeclarations$default(this, node, null, 1, null);
                if (topLevelDeclarations.size() == 1) {
                    TopLevelDeclaration topLevelDeclaration = (TopLevelDeclaration)CollectionsKt.first((List)topLevelDeclarations);
                    if (Intrinsics.areEqual((Object)topLevelDeclaration.getElementType(), (Object)ElementType.INSTANCE.getOBJECT_DECLARATION()) || Intrinsics.areEqual((Object)topLevelDeclaration.getElementType(), (Object)ElementType.INSTANCE.getTYPEALIAS())) {
                        String pascalCaseIdentifier = this.toPascalCase(topLevelDeclaration.getIdentifier());
                        this.shouldMatchFileName(fileName, pascalCaseIdentifier, emit);
                    } else {
                        this.shouldMatchPascalCase(fileName, emit);
                    }
                } else {
                    this.shouldMatchPascalCase(fileName, emit);
                }
            }
            this.stopTraversalOfAST();
        }
    }

    private final List<TopLevelDeclaration> topLevelDeclarations(ASTNode $this$topLevelDeclarations, IElementType elementType) {
        return SequencesKt.toList((Sequence)SequencesKt.distinct((Sequence)SequencesKt.mapNotNull((Sequence)SequencesKt.filter((Sequence)SequencesKt.filter((Sequence)ASTNodeExtensionKt.getChildren20((ASTNode)$this$topLevelDeclarations), arg_0 -> FilenameRule.topLevelDeclarations$lambda$0(elementType, arg_0)), arg_0 -> FilenameRule.topLevelDeclarations$lambda$1(this, arg_0)), arg_0 -> FilenameRule.topLevelDeclarations$lambda$2(this, arg_0))));
    }

    static /* synthetic */ List topLevelDeclarations$default(FilenameRule filenameRule, ASTNode aSTNode, IElementType iElementType, int n, Object object) {
        if ((n & 1) != 0) {
            iElementType = null;
        }
        return filenameRule.topLevelDeclarations(aSTNode, iElementType);
    }

    /*
     * WARNING - void declaration
     */
    private final boolean doesNotHavePrivateModifier(ASTNode $this$doesNotHavePrivateModifier) {
        boolean bl;
        block3: {
            Sequence sequence;
            ASTNode aSTNode = $this$doesNotHavePrivateModifier.findChildByType(ElementType.INSTANCE.getMODIFIER_LIST());
            if (aSTNode != null && (sequence = ASTNodeExtensionKt.getChildren20((ASTNode)aSTNode)) != null) {
                void $this$none$iv;
                Sequence sequence2 = sequence;
                boolean $i$f$none = false;
                for (Object element$iv : $this$none$iv) {
                    ASTNode it = (ASTNode)element$iv;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual((Object)it.getText(), (Object)"private")) continue;
                    bl = false;
                    break block3;
                }
                bl = true;
            } else {
                bl = true;
            }
        }
        return bl;
    }

    private final boolean hasTopLevelDeclarationNotExtending(ASTNode $this$hasTopLevelDeclarationNotExtending, String className) {
        boolean bl;
        block1: {
            Sequence $this$any$iv = SequencesKt.filter((Sequence)ASTNodeExtensionKt.getChildren20((ASTNode)$this$hasTopLevelDeclarationNotExtending), arg_0 -> FilenameRule.hasTopLevelDeclarationNotExtending$lambda$0(this, arg_0));
            boolean $i$f$any = false;
            for (Object element$iv : $this$any$iv) {
                ASTNode it = (ASTNode)element$iv;
                boolean bl2 = false;
                if (!(this.isNotClassRelatedTopLevelDeclaration(it) || this.isFunctionNotExtending(it, className))) continue;
                bl = true;
                break block1;
            }
            bl = false;
        }
        return bl;
    }

    private final boolean isNotClassRelatedTopLevelDeclaration(ASTNode $this$isNotClassRelatedTopLevelDeclaration) {
        return NON_CLASS_RELATED_TOP_LEVEL_DECLARATION_TYPES.contains($this$isNotClassRelatedTopLevelDeclaration.getElementType());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isFunctionNotExtending(ASTNode $this$isFunctionNotExtending, String className) {
        if (!Intrinsics.areEqual((Object)$this$isFunctionNotExtending.getElementType(), (Object)ElementType.INSTANCE.getFUN())) return false;
        ASTNode aSTNode = $this$isFunctionNotExtending.findChildByType(ElementType.INSTANCE.getTYPE_REFERENCE());
        Object object = aSTNode;
        if (aSTNode == null) return true;
        String string = object.getText();
        object = string;
        if (string == null) return true;
        Object object2 = object;
        boolean bl = false;
        if (StringsKt.contains$default((CharSequence)((CharSequence)object2), (CharSequence)className, (boolean)false, (int)2, null)) return false;
        return true;
    }

    private final void shouldMatchClassName(String $this$shouldMatchClassName, String className, Function3<? super Integer, ? super String, ? super Boolean, ? extends AutocorrectDecision> emit) {
        if (!Intrinsics.areEqual((Object)$this$shouldMatchClassName, (Object)className)) {
            emit.invoke((Object)0, (Object)("File '" + $this$shouldMatchClassName + ".kt' contains a single class, and possibly related top level declarations for that class. The file should be named after the class, '" + className + ".kt'"), (Object)false);
        }
    }

    private final String toPascalCase(String $this$toPascalCase) {
        String string;
        String string2 = $this$toPascalCase;
        if (((CharSequence)string2).length() > 0) {
            char it = string2.charAt(0);
            boolean bl = false;
            char c = Character.toUpperCase(it);
            String string3 = string2;
            int n = 1;
            String string4 = string3.substring(n);
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"substring(...)");
            string3 = string4;
            string = c + string3;
        } else {
            string = string2;
        }
        return string;
    }

    private final void shouldMatchFileName(String $this$shouldMatchFileName, String filename, Function3<? super Integer, ? super String, ? super Boolean, ? extends AutocorrectDecision> emit) {
        if (!Intrinsics.areEqual((Object)$this$shouldMatchFileName, (Object)filename)) {
            emit.invoke((Object)0, (Object)("File '" + $this$shouldMatchFileName + ".kt' contains a single top level declaration and should be named '" + filename + ".kt'"), (Object)false);
        }
    }

    private final void shouldMatchPascalCase(String $this$shouldMatchPascalCase, Function3<? super Integer, ? super String, ? super Boolean, ? extends AutocorrectDecision> emit) {
        CharSequence charSequence = $this$shouldMatchPascalCase;
        if (!PASCAL_CASE_REGEX.matches(charSequence)) {
            emit.invoke((Object)0, (Object)("File name '" + $this$shouldMatchPascalCase + ".kt' should conform PascalCase"), (Object)false);
        }
    }

    private final TopLevelDeclaration toTopLevelDeclaration(ASTNode $this$toTopLevelDeclaration) {
        TopLevelDeclaration topLevelDeclaration;
        String string;
        String string2;
        ASTNode aSTNode = $this$toTopLevelDeclaration.findChildByType(ElementType.INSTANCE.getIDENTIFIER());
        if (aSTNode != null && (string2 = aSTNode.getText()) != null && (string = StringsKt.removeSurrounding((String)string2, (CharSequence)"`")) != null) {
            String it = string;
            boolean bl = false;
            IElementType iElementType = $this$toTopLevelDeclaration.getElementType();
            Intrinsics.checkNotNullExpressionValue((Object)iElementType, (String)"getElementType(...)");
            topLevelDeclaration = new TopLevelDeclaration(iElementType, it);
        } else {
            topLevelDeclaration = null;
        }
        return topLevelDeclaration;
    }

    private static final boolean topLevelDeclarations$lambda$0(IElementType $elementType, ASTNode it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return $elementType == null || Intrinsics.areEqual((Object)it.getElementType(), (Object)$elementType);
    }

    private static final boolean topLevelDeclarations$lambda$1(FilenameRule this$0, ASTNode it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return this$0.doesNotHavePrivateModifier(it);
    }

    private static final TopLevelDeclaration topLevelDeclarations$lambda$2(FilenameRule this$0, ASTNode it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return this$0.toTopLevelDeclaration(it);
    }

    private static final boolean hasTopLevelDeclarationNotExtending$lambda$0(FilenameRule this$0, ASTNode it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return this$0.doesNotHavePrivateModifier(it);
    }

    static {
        Object[] objectArray = new IElementType[]{ElementType.INSTANCE.getOBJECT_DECLARATION(), ElementType.INSTANCE.getTYPEALIAS(), ElementType.INSTANCE.getPROPERTY()};
        NON_CLASS_RELATED_TOP_LEVEL_DECLARATION_TYPES = CollectionsKt.listOf((Object[])objectArray);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0082\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\r"}, d2={"Lcom/pinterest/ktlint/ruleset/standard/rules/FilenameRule$Companion;", "", "<init>", "()V", "PASCAL_CASE_REGEX", "Lkotlin/text/Regex;", "getPASCAL_CASE_REGEX", "()Lkotlin/text/Regex;", "NON_CLASS_RELATED_TOP_LEVEL_DECLARATION_TYPES", "", "Lorg/jetbrains/kotlin/com/intellij/psi/tree/IElementType;", "getNON_CLASS_RELATED_TOP_LEVEL_DECLARATION_TYPES", "()Ljava/util/List;", "ktlint-ruleset-standard"})
    private static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Regex getPASCAL_CASE_REGEX() {
            return PASCAL_CASE_REGEX;
        }

        @NotNull
        public final List<IElementType> getNON_CLASS_RELATED_TOP_LEVEL_DECLARATION_TYPES() {
            return NON_CLASS_RELATED_TOP_LEVEL_DECLARATION_TYPES;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0005H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0015"}, d2={"Lcom/pinterest/ktlint/ruleset/standard/rules/FilenameRule$TopLevelDeclaration;", "", "elementType", "Lorg/jetbrains/kotlin/com/intellij/psi/tree/IElementType;", "identifier", "", "<init>", "(Lorg/jetbrains/kotlin/com/intellij/psi/tree/IElementType;Ljava/lang/String;)V", "getElementType", "()Lorg/jetbrains/kotlin/com/intellij/psi/tree/IElementType;", "getIdentifier", "()Ljava/lang/String;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "ktlint-ruleset-standard"})
    private static final class TopLevelDeclaration {
        @NotNull
        private final IElementType elementType;
        @NotNull
        private final String identifier;

        public TopLevelDeclaration(@NotNull IElementType elementType, @NotNull String identifier) {
            Intrinsics.checkNotNullParameter((Object)elementType, (String)"elementType");
            Intrinsics.checkNotNullParameter((Object)identifier, (String)"identifier");
            this.elementType = elementType;
            this.identifier = identifier;
        }

        @NotNull
        public final IElementType getElementType() {
            return this.elementType;
        }

        @NotNull
        public final String getIdentifier() {
            return this.identifier;
        }

        @NotNull
        public final IElementType component1() {
            return this.elementType;
        }

        @NotNull
        public final String component2() {
            return this.identifier;
        }

        @NotNull
        public final TopLevelDeclaration copy(@NotNull IElementType elementType, @NotNull String identifier) {
            Intrinsics.checkNotNullParameter((Object)elementType, (String)"elementType");
            Intrinsics.checkNotNullParameter((Object)identifier, (String)"identifier");
            return new TopLevelDeclaration(elementType, identifier);
        }

        public static /* synthetic */ TopLevelDeclaration copy$default(TopLevelDeclaration topLevelDeclaration, IElementType iElementType, String string, int n, Object object) {
            if ((n & 1) != 0) {
                iElementType = topLevelDeclaration.elementType;
            }
            if ((n & 2) != 0) {
                string = topLevelDeclaration.identifier;
            }
            return topLevelDeclaration.copy(iElementType, string);
        }

        @NotNull
        public String toString() {
            return "TopLevelDeclaration(elementType=" + this.elementType + ", identifier=" + this.identifier + ')';
        }

        public int hashCode() {
            int result = this.elementType.hashCode();
            result = result * 31 + this.identifier.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof TopLevelDeclaration)) {
                return false;
            }
            TopLevelDeclaration topLevelDeclaration = (TopLevelDeclaration)other;
            if (!Intrinsics.areEqual((Object)this.elementType, (Object)topLevelDeclaration.elementType)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.identifier, (Object)topLevelDeclaration.identifier);
        }
    }
}

