/*
 * Decompiled with CFR 0.152.
 */
package com.pinterest.ktlint.ruleset.standard.rules;

import com.pinterest.ktlint.rule.engine.core.api.ASTNodeExtensionKt;
import com.pinterest.ktlint.rule.engine.core.api.AutocorrectDecision;
import com.pinterest.ktlint.rule.engine.core.api.ElementType;
import com.pinterest.ktlint.rule.engine.core.api.SinceKtlint;
import com.pinterest.ktlint.rule.engine.core.api.editorconfig.EditorConfig;
import com.pinterest.ktlint.rule.engine.core.api.editorconfig.EditorConfigProperty;
import com.pinterest.ktlint.ruleset.standard.StandardRule;
import com.pinterest.ktlint.ruleset.standard.rules.ImportOrderingRuleKt;
import com.pinterest.ktlint.ruleset.standard.rules.internal.importordering.ImportLayoutParserKt;
import com.pinterest.ktlint.ruleset.standard.rules.internal.importordering.ImportSorter;
import com.pinterest.ktlint.ruleset.standard.rules.internal.importordering.PatternEntry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.ec4j.core.model.PropertyType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.lang.ASTNode;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiWhiteSpace;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.PsiWhiteSpaceImpl;
import org.jetbrains.kotlin.psi.KtImportDirective;
import org.jetbrains.kotlin.resolve.ImportPath;

@SinceKtlint(version="0.10", status=SinceKtlint.Status.STABLE)
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\n\b\u0007\u0018\u0000 '2\u00020\u0001:\u0001'B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J]\u0010\r\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u000f2K\u0010\u0010\u001aG\u0012\u0013\u0012\u00110\u0012\u00a2\u0006\f\b\u0013\u0012\b\b\u0014\u0012\u0004\b\b(\u0015\u0012\u0013\u0012\u00110\u0016\u00a2\u0006\f\b\u0013\u0012\b\b\u0014\u0012\u0004\b\b(\u0017\u0012\u0013\u0012\u00110\u0018\u00a2\u0006\f\b\u0013\u0012\b\b\u0014\u0012\u0004\b\b(\u0019\u0012\u0004\u0012\u00020\u001a0\u0011H\u0016Jz\u0010\u001b\u001a\u0014\u0012\u0004\u0012\u00020\u0018\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0\u00050\u001c2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u000f0\u001e2K\u0010\u0010\u001aG\u0012\u0013\u0012\u00110\u0012\u00a2\u0006\f\b\u0013\u0012\b\b\u0014\u0012\u0004\b\b(\u0015\u0012\u0013\u0012\u00110\u0016\u00a2\u0006\f\b\u0013\u0012\b\b\u0014\u0012\u0004\b\b(\u0017\u0012\u0013\u0012\u00110\u0018\u00a2\u0006\f\b\u0013\u0012\b\b\u0014\u0012\u0004\b\b(\u0019\u0012\u0004\u0012\u00020\u001a0\u0011H\u0002\u00a2\u0006\u0002\u0010\u001fJ$\u0010 \u001a\u00020\u00182\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\u000f0\u00052\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0005H\u0002J\b\u0010#\u001a\u00020\u0018H\u0002J\u001b\u0010$\u001a\u00020\u00182\f\u0010%\u001a\b\u0012\u0004\u0012\u00020\u000f0\u001eH\u0002\u00a2\u0006\u0002\u0010&R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lcom/pinterest/ktlint/ruleset/standard/rules/ImportOrderingRule;", "Lcom/pinterest/ktlint/ruleset/standard/StandardRule;", "<init>", "()V", "importsLayout", "", "Lcom/pinterest/ktlint/ruleset/standard/rules/internal/importordering/PatternEntry;", "importSorter", "Lcom/pinterest/ktlint/ruleset/standard/rules/internal/importordering/ImportSorter;", "beforeFirstNode", "", "editorConfig", "Lcom/pinterest/ktlint/rule/engine/core/api/editorconfig/EditorConfig;", "beforeVisitChildNodes", "node", "Lorg/jetbrains/kotlin/com/intellij/lang/ASTNode;", "emit", "Lkotlin/Function3;", "", "Lkotlin/ParameterName;", "name", "offset", "", "errorMessage", "", "canBeAutoCorrected", "Lcom/pinterest/ktlint/rule/engine/core/api/AutocorrectDecision;", "getUniqueImportsAndBlankLines", "Lkotlin/Pair;", "children", "", "([Lorg/jetbrains/kotlin/com/intellij/lang/ASTNode;Lkotlin/jvm/functions/Function3;)Lkotlin/Pair;", "importsAreEqual", "actual", "expected", "isCustomLayout", "hasTooMuchWhitespace", "nodes", "([Lorg/jetbrains/kotlin/com/intellij/lang/ASTNode;)Z", "Companion", "ktlint-ruleset-standard"})
@SourceDebugExtension(value={"SMAP\nImportOrderingRule.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ImportOrderingRule.kt\ncom/pinterest/ktlint/ruleset/standard/rules/ImportOrderingRule\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 4 AutocorrectDecision.kt\ncom/pinterest/ktlint/rule/engine/core/api/AutocorrectDecisionKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 6 ASTNodeExtension.kt\ncom/pinterest/ktlint/rule/engine/core/api/ASTNodeExtensionKt\n+ 7 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 8 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n*L\n1#1,284:1\n12970#2,2:285\n13805#2:301\n13806#2:308\n12970#2,2:312\n1292#3,3:287\n19#4:290\n18#4:291\n19#4:305\n18#4:306\n1#5:292\n1#5:307\n319#6:293\n2783#7,7:294\n1740#7,3:309\n1104#8,3:302\n*S KotlinDebug\n*F\n+ 1 ImportOrderingRule.kt\ncom/pinterest/ktlint/ruleset/standard/rules/ImportOrderingRule\n*L\n75#1:285,2\n150#1:301\n150#1:308\n187#1:312,2\n89#1:287,3\n124#1:290\n124#1:291\n161#1:305\n161#1:306\n124#1:292\n161#1:307\n127#1:293\n128#1:294,7\n177#1:309,3\n152#1:302,3\n*E\n"})
public final class ImportOrderingRule
extends StandardRule {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private List<PatternEntry> importsLayout;
    private ImportSorter importSorter;
    @NotNull
    private static final List<PatternEntry> ASCII_PATTERN = ImportLayoutParserKt.parseImportsLayout("*");
    @NotNull
    private static final List<PatternEntry> IDEA_PATTERN = ImportLayoutParserKt.parseImportsLayout("*,java.**,javax.**,kotlin.**,^");
    @NotNull
    private static final String IDEA_ERROR_MESSAGE = "Imports must be ordered in lexicographic order without any empty lines in-between with \"java\", \"javax\", \"kotlin\" and aliases in the end";
    @NotNull
    private static final String ASCII_ERROR_MESSAGE = "Imports must be ordered in lexicographic order without any empty lines in-between";
    @NotNull
    private static final String CUSTOM_ERROR_MESSAGE = "Imports must be ordered according to the pattern specified in .editorconfig";
    @NotNull
    private static final Map<List<PatternEntry>, String> ERROR_MESSAGES;
    @NotNull
    private static final Function2<String, String, PropertyType.PropertyValue<List<PatternEntry>>> EDITOR_CONFIG_PROPERTY_PARSER;
    @NotNull
    private static final EditorConfigProperty<List<PatternEntry>> IJ_KOTLIN_IMPORTS_LAYOUT_PROPERTY;

    public ImportOrderingRule() {
        super("import-ordering", null, SetsKt.setOf(IJ_KOTLIN_IMPORTS_LAYOUT_PROPERTY), 2, null);
    }

    public void beforeFirstNode(@NotNull EditorConfig editorConfig) {
        Intrinsics.checkNotNullParameter((Object)editorConfig, (String)"editorConfig");
        this.importsLayout = (List)editorConfig.get(IJ_KOTLIN_IMPORTS_LAYOUT_PROPERTY);
        List<PatternEntry> list = this.importsLayout;
        if (list == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"importsLayout");
            list = null;
        }
        this.importSorter = new ImportSorter(list);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void beforeVisitChildNodes(@NotNull ASTNode node, @NotNull Function3<? super Integer, ? super String, ? super Boolean, ? extends AutocorrectDecision> emit) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter(emit, (String)"emit");
        if (Intrinsics.areEqual((Object)node.getElementType(), (Object)ElementType.INSTANCE.getIMPORT_LIST())) {
            ASTNode[] aSTNodeArray = node.getChildren(null);
            Intrinsics.checkNotNullExpressionValue((Object)aSTNodeArray, (String)"getChildren(...)");
            ASTNode[] children = aSTNodeArray;
            if (!(children.length == 0)) {
                void $this$fold$iv;
                boolean bl;
                List imports;
                boolean autoCorrectDuplicateImports;
                block22: {
                    Pair<Boolean, List<ASTNode>> pair = this.getUniqueImportsAndBlankLines(children, emit);
                    autoCorrectDuplicateImports = (Boolean)pair.component1();
                    imports = (List)pair.component2();
                    ASTNode[] $this$any$iv = children;
                    boolean $i$f$any = false;
                    int n = $this$any$iv.length;
                    for (int i = 0; i < n; ++i) {
                        ASTNode element$iv;
                        ASTNode it = element$iv = $this$any$iv[i];
                        boolean bl2 = false;
                        if (!(Intrinsics.areEqual((Object)it.getElementType(), (Object)ElementType.INSTANCE.getBLOCK_COMMENT()) || Intrinsics.areEqual((Object)it.getElementType(), (Object)ElementType.INSTANCE.getEOL_COMMENT()))) continue;
                        bl = true;
                        break block22;
                    }
                    bl = false;
                }
                boolean hasComments = bl;
                Sequence sequence = SequencesKt.mapNotNull((Sequence)CollectionsKt.asSequence((Iterable)imports), ImportOrderingRule::beforeVisitChildNodes$lambda$1);
                ImportSorter importSorter = this.importSorter;
                if (importSorter == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"importSorter");
                    importSorter = null;
                }
                Sequence sortedImports = SequencesKt.map((Sequence)SequencesKt.sortedWith((Sequence)sequence, (Comparator)importSorter), ImportOrderingRule::beforeVisitChildNodes$lambda$2);
                List sortedImportsWithSpaces = new ArrayList();
                Sequence sequence2 = sortedImports;
                AutocorrectDecision initial$iv = null;
                boolean $i$f$fold = false;
                AutocorrectDecision accumulator$iv = initial$iv;
                for (Object element$iv : $this$fold$iv) {
                    void current;
                    ImportSorter importSorter2;
                    int n;
                    ASTNode aSTNode = (ASTNode)element$iv;
                    AutocorrectDecision prev = accumulator$iv;
                    boolean bl3 = false;
                    if (prev == null) {
                        n = -1;
                    } else {
                        int index1;
                        ImportSorter importSorter3 = this.importSorter;
                        if (importSorter3 == null) {
                            Intrinsics.throwUninitializedPropertyAccessException((String)"importSorter");
                            importSorter3 = null;
                        }
                        PsiElement psiElement = prev.getPsi();
                        Intrinsics.checkNotNull((Object)psiElement, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtImportDirective");
                        ImportPath importPath = ((KtImportDirective)psiElement).getImportPath();
                        Intrinsics.checkNotNull((Object)importPath);
                        n = index1 = importSorter3.findImportIndex(importPath);
                    }
                    if ((importSorter2 = this.importSorter) == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"importSorter");
                        importSorter2 = null;
                    }
                    PsiElement psiElement = current.getPsi();
                    Intrinsics.checkNotNull((Object)psiElement, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtImportDirective");
                    ImportPath importPath = ((KtImportDirective)psiElement).getImportPath();
                    Intrinsics.checkNotNull((Object)importPath);
                    int index2 = importSorter2.findImportIndex(importPath);
                    boolean hasBlankLines = false;
                    for (int i = index1 + 1; i < index2; ++i) {
                        ImportSorter importSorter4 = this.importSorter;
                        if (importSorter4 == null) {
                            Intrinsics.throwUninitializedPropertyAccessException((String)"importSorter");
                            importSorter4 = null;
                        }
                        if (!Intrinsics.areEqual((Object)importSorter4.getPatterns().get(i), (Object)PatternEntry.Companion.getBLANK_LINE_ENTRY())) continue;
                        hasBlankLines = true;
                        break;
                    }
                    if (hasBlankLines && prev != null) {
                        ((Collection)sortedImportsWithSpaces).add(new PsiWhiteSpaceImpl((CharSequence)"\n\n"));
                    }
                    ((Collection)sortedImportsWithSpaces).add(current);
                    accumulator$iv = current;
                }
                if (hasComments) {
                    Integer n = node.getStartOffset();
                    StringBuilder stringBuilder = new StringBuilder();
                    List<PatternEntry> list = this.importsLayout;
                    if (list == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"importsLayout");
                        list = null;
                    }
                    emit.invoke((Object)n, (Object)stringBuilder.append(ERROR_MESSAGES.getOrDefault(list, CUSTOM_ERROR_MESSAGE)).append(" -- no autocorrection due to comments in the import list").toString(), (Object)false);
                } else {
                    boolean autoCorrectWhitespace = this.hasTooMuchWhitespace(children) && !this.isCustomLayout();
                    boolean autoCorrectSortOrder = !this.importsAreEqual(imports, sortedImportsWithSpaces);
                    boolean autocorrect = false;
                    autocorrect = autoCorrectDuplicateImports;
                    if (autoCorrectSortOrder || autoCorrectWhitespace) {
                        Object bl3;
                        void $this$ifAutocorrectAllowed$iv;
                        Object element$iv;
                        Integer n = node.getStartOffset();
                        List<PatternEntry> list = this.importsLayout;
                        if (list == null) {
                            Intrinsics.throwUninitializedPropertyAccessException((String)"importsLayout");
                            list = null;
                        }
                        accumulator$iv = (AutocorrectDecision)emit.invoke((Object)n, (Object)ERROR_MESSAGES.getOrDefault(list, CUSTOM_ERROR_MESSAGE), (Object)true);
                        boolean $i$f$ifAutocorrectAllowed = false;
                        Object it$iv = element$iv = $this$ifAutocorrectAllowed$iv;
                        boolean bl4 = false;
                        Object object = bl3 = $this$ifAutocorrectAllowed$iv == AutocorrectDecision.ALLOW_AUTOCORRECT ? element$iv : null;
                        if (bl3 != null) {
                            it$iv = bl3;
                            boolean bl5 = false;
                            boolean bl6 = false;
                            autocorrect = true;
                        }
                    }
                    if (autocorrect) {
                        ASTNode aSTNode = node.getFirstChildNode();
                        ASTNode aSTNode2 = node.getLastChildNode();
                        Intrinsics.checkNotNullExpressionValue((Object)aSTNode2, (String)"getLastChildNode(...)");
                        ASTNode $this$nextSibling20$iv = aSTNode2;
                        boolean $i$f$getNextSibling20 = false;
                        node.removeRange(aSTNode, $this$nextSibling20$iv.getTreeNext());
                        Iterable $this$reduce$iv = sortedImportsWithSpaces;
                        boolean $i$f$reduce = false;
                        Iterator iterator$iv = $this$reduce$iv.iterator();
                        if (!iterator$iv.hasNext()) {
                            throw new UnsupportedOperationException("Empty collection can't be reduced.");
                        }
                        Object accumulator$iv2 = iterator$iv.next();
                        while (iterator$iv.hasNext()) {
                            void next;
                            ASTNode bl5 = (ASTNode)iterator$iv.next();
                            ASTNode current = (ASTNode)accumulator$iv2;
                            boolean bl7 = false;
                            node.addChild(current, null);
                            if (!ASTNodeExtensionKt.isWhiteSpace20((ASTNode)current) && !ASTNodeExtensionKt.isWhiteSpace20((ASTNode)next)) {
                                node.addChild((ASTNode)new PsiWhiteSpaceImpl((CharSequence)"\n"), null);
                            }
                            accumulator$iv2 = next;
                        }
                        node.addChild((ASTNode)CollectionsKt.last((List)sortedImportsWithSpaces), null);
                    }
                }
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final Pair<Boolean, List<ASTNode>> getUniqueImportsAndBlankLines(ASTNode[] children, Function3<? super Integer, ? super String, ? super Boolean, ? extends AutocorrectDecision> emit) {
        boolean autoCorrectDuplicateImports = false;
        List imports = new ArrayList();
        Set importTextSet = new LinkedHashSet();
        ASTNode[] $this$forEach$iv = children;
        boolean $i$f$forEach = false;
        int n = $this$forEach$iv.length;
        for (int i = 0; i < n; ++i) {
            Object object;
            void $this$ifAutocorrectAllowed$iv;
            CharSequence $this$count$iv;
            ASTNode element$iv;
            ASTNode current = element$iv = $this$forEach$iv[i];
            boolean bl = false;
            if (ASTNodeExtensionKt.isWhiteSpace20((ASTNode)current)) {
                String string = current.getText();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
                $this$count$iv = string;
                boolean $i$f$count = false;
                int count$iv = 0;
                for (int j = 0; j < $this$count$iv.length(); ++j) {
                    char element$iv2;
                    char it = element$iv2 = $this$count$iv.charAt(j);
                    boolean bl2 = false;
                    if (!(it == '\n')) continue;
                    ++count$iv;
                }
                if (count$iv > 1) {
                    ((Collection)imports).add(current);
                    continue;
                }
            }
            if (!Intrinsics.areEqual((Object)current.getElementType(), (Object)ElementType.INSTANCE.getIMPORT_DIRECTIVE())) continue;
            String string = current.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
            if (importTextSet.add(string)) {
                ((Collection)imports).add(current);
                continue;
            }
            $this$count$iv = (AutocorrectDecision)emit.invoke((Object)current.getStartOffset(), (Object)("Duplicate '" + current.getText() + "' found"), (Object)true);
            boolean $i$f$ifAutocorrectAllowed = false;
            void var15_16 = $this$ifAutocorrectAllowed$iv;
            Object it$iv = var15_16;
            boolean bl3 = false;
            Object object2 = object = $this$ifAutocorrectAllowed$iv == AutocorrectDecision.ALLOW_AUTOCORRECT ? var15_16 : null;
            if (object == null) continue;
            it$iv = object;
            boolean bl4 = false;
            boolean bl5 = false;
            autoCorrectDuplicateImports = true;
        }
        return TuplesKt.to((Object)autoCorrectDuplicateImports, (Object)imports);
    }

    private final boolean importsAreEqual(List<? extends ASTNode> actual, List<? extends ASTNode> expected) {
        boolean bl;
        block6: {
            if (actual.size() != expected.size()) {
                return false;
            }
            List combined = CollectionsKt.zip((Iterable)actual, (Iterable)expected);
            Iterable $this$all$iv = combined;
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    boolean bl2;
                    Pair pair = (Pair)element$iv;
                    boolean bl3 = false;
                    ASTNode first = (ASTNode)pair.component1();
                    ASTNode second = (ASTNode)pair.component2();
                    if (ASTNodeExtensionKt.isWhiteSpace20((ASTNode)first) && ASTNodeExtensionKt.isWhiteSpace20((ASTNode)second)) {
                        Intrinsics.checkNotNull((Object)first, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.com.intellij.psi.PsiWhiteSpace");
                        String string = ((PsiWhiteSpace)first).getText();
                        Intrinsics.checkNotNull((Object)second, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.com.intellij.psi.PsiWhiteSpace");
                        bl2 = Intrinsics.areEqual((Object)string, (Object)((PsiWhiteSpace)second).getText());
                    } else {
                        bl2 = Intrinsics.areEqual((Object)first, (Object)second);
                    }
                    if (bl2) continue;
                    bl = false;
                    break block6;
                }
                bl = true;
            }
        }
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isCustomLayout() {
        List<PatternEntry> list = this.importsLayout;
        if (list == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"importsLayout");
            list = null;
        }
        if (Intrinsics.areEqual(list, IDEA_PATTERN)) return false;
        List<PatternEntry> list2 = this.importsLayout;
        if (list2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"importsLayout");
            list2 = null;
        }
        if (Intrinsics.areEqual(list2, ASCII_PATTERN)) return false;
        return true;
    }

    private final boolean hasTooMuchWhitespace(ASTNode[] nodes) {
        boolean bl;
        block1: {
            ASTNode[] $this$any$iv = nodes;
            boolean $i$f$any = false;
            int n = $this$any$iv.length;
            for (int i = 0; i < n; ++i) {
                ASTNode element$iv;
                ASTNode it = element$iv = $this$any$iv[i];
                boolean bl2 = false;
                if (!ASTNodeExtensionKt.isWhiteSpaceWithoutNewline20((ASTNode)it)) continue;
                bl = true;
                break block1;
            }
            bl = false;
        }
        return bl;
    }

    private static final KtImportDirective beforeVisitChildNodes$lambda$1(ASTNode it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        PsiElement psiElement = it.getPsi();
        return psiElement instanceof KtImportDirective ? (KtImportDirective)psiElement : null;
    }

    private static final ASTNode beforeVisitChildNodes$lambda$2(KtImportDirective it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getNode();
    }

    private static final PropertyType.PropertyValue EDITOR_CONFIG_PROPERTY_PARSER$lambda$0(String string, String value) {
        CharSequence charSequence;
        Intrinsics.checkNotNullParameter((Object)string, (String)"<unused var>");
        CharSequence charSequence2 = value;
        if (charSequence2 == null || StringsKt.isBlank((CharSequence)charSequence2)) {
            charSequence2 = PropertyType.PropertyValue.invalid((String)value, (String)"Import layout must contain at least one entry of a wildcard symbol (*)");
            Intrinsics.checkNotNull((Object)charSequence2);
            charSequence = charSequence2;
        } else if (Intrinsics.areEqual((Object)value, (Object)"idea")) {
            ImportOrderingRuleKt.access$getLOGGER$p().warn(ImportOrderingRule::EDITOR_CONFIG_PROPERTY_PARSER$lambda$0$0);
            charSequence2 = PropertyType.PropertyValue.valid((String)value, IDEA_PATTERN);
            Intrinsics.checkNotNull((Object)charSequence2);
            charSequence = charSequence2;
        } else if (Intrinsics.areEqual((Object)value, (Object)"ascii")) {
            ImportOrderingRuleKt.access$getLOGGER$p().warn(ImportOrderingRule::EDITOR_CONFIG_PROPERTY_PARSER$lambda$0$1);
            charSequence2 = PropertyType.PropertyValue.valid((String)value, ASCII_PATTERN);
            Intrinsics.checkNotNull((Object)charSequence2);
            charSequence = charSequence2;
        } else {
            PropertyType.PropertyValue propertyValue;
            try {
                propertyValue = PropertyType.PropertyValue.valid((String)value, ImportLayoutParserKt.parseImportsLayout(value));
            }
            catch (IllegalArgumentException e) {
                propertyValue = PropertyType.PropertyValue.invalid((String)value, (String)("Unexpected imports layout: " + value));
            }
            charSequence2 = propertyValue;
            Intrinsics.checkNotNull((Object)charSequence2);
            charSequence = charSequence2;
        }
        return charSequence;
    }

    private static final Object EDITOR_CONFIG_PROPERTY_PARSER$lambda$0$0() {
        return "`idea` is deprecated! Please use `*,java.**,javax.**,kotlin.**,^` instead to ensure that the Kotlin IDE plugin recognizes the value";
    }

    private static final Object EDITOR_CONFIG_PROPERTY_PARSER$lambda$0$1() {
        return "`ascii` is deprecated! Please use `*` instead to ensure that the Kotlin IDE plugin recognizes the value";
    }

    private static final PropertyType.PropertyValue IJ_KOTLIN_IMPORTS_LAYOUT_PROPERTY$lambda$0(Function2 $tmp0, String p0, String p1) {
        return (PropertyType.PropertyValue)$tmp0.invoke((Object)p0, (Object)p1);
    }

    private static final String IJ_KOTLIN_IMPORTS_LAYOUT_PROPERTY$lambda$1(List it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return CollectionsKt.joinToString$default((Iterable)it, (CharSequence)",", null, null, (int)0, null, null, (int)62, null);
    }

    static {
        Pair[] pairArray = new Pair[]{TuplesKt.to(IDEA_PATTERN, (Object)IDEA_ERROR_MESSAGE), TuplesKt.to(ASCII_PATTERN, (Object)ASCII_ERROR_MESSAGE)};
        ERROR_MESSAGES = MapsKt.mapOf((Pair[])pairArray);
        EDITOR_CONFIG_PROPERTY_PARSER = ImportOrderingRule::EDITOR_CONFIG_PROPERTY_PARSER$lambda$0;
        IJ_KOTLIN_IMPORTS_LAYOUT_PROPERTY = new EditorConfigProperty(new PropertyType("ij_kotlin_imports_layout", "Defines imports order layout for Kotlin files", (arg_0, arg_1) -> ImportOrderingRule.IJ_KOTLIN_IMPORTS_LAYOUT_PROPERTY$lambda$0(EDITOR_CONFIG_PROPERTY_PARSER, arg_0, arg_1), new String[0]), IDEA_PATTERN, null, null, ASCII_PATTERN, null, ImportOrderingRule::IJ_KOTLIN_IMPORTS_LAYOUT_PROPERTY$lambda$1, null, null, null, 940, null);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R \u0010\f\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0004\u0012\u00020\t0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R.\u0010\u000e\u001a\"\u0012\u0004\u0012\u00020\t\u0012\u0006\u0012\u0004\u0018\u00010\t\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00050\u00100\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001d\u0010\u0011\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00050\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006\u0015"}, d2={"Lcom/pinterest/ktlint/ruleset/standard/rules/ImportOrderingRule$Companion;", "", "<init>", "()V", "ASCII_PATTERN", "", "Lcom/pinterest/ktlint/ruleset/standard/rules/internal/importordering/PatternEntry;", "IDEA_PATTERN", "IDEA_ERROR_MESSAGE", "", "ASCII_ERROR_MESSAGE", "CUSTOM_ERROR_MESSAGE", "ERROR_MESSAGES", "", "EDITOR_CONFIG_PROPERTY_PARSER", "Lkotlin/Function2;", "Lorg/ec4j/core/model/PropertyType$PropertyValue;", "IJ_KOTLIN_IMPORTS_LAYOUT_PROPERTY", "Lcom/pinterest/ktlint/rule/engine/core/api/editorconfig/EditorConfigProperty;", "getIJ_KOTLIN_IMPORTS_LAYOUT_PROPERTY", "()Lcom/pinterest/ktlint/rule/engine/core/api/editorconfig/EditorConfigProperty;", "ktlint-ruleset-standard"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final EditorConfigProperty<List<PatternEntry>> getIJ_KOTLIN_IMPORTS_LAYOUT_PROPERTY() {
            return IJ_KOTLIN_IMPORTS_LAYOUT_PROPERTY;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

