/*
 * Decompiled with CFR 0.152.
 */
package com.pinterest.ktlint.ruleset.standard.rules;

import com.pinterest.ktlint.rule.engine.core.api.ASTNodeExtensionKt;
import com.pinterest.ktlint.rule.engine.core.api.AutocorrectDecision;
import com.pinterest.ktlint.rule.engine.core.api.ElementType;
import com.pinterest.ktlint.rule.engine.core.api.IndentConfig;
import com.pinterest.ktlint.rule.engine.core.api.KtlintKotlinCompiler;
import com.pinterest.ktlint.rule.engine.core.api.Rule;
import com.pinterest.ktlint.rule.engine.core.api.RuleAutocorrectApproveHandler;
import com.pinterest.ktlint.rule.engine.core.api.SinceKtlint;
import com.pinterest.ktlint.rule.engine.core.api.editorconfig.EditorConfig;
import com.pinterest.ktlint.rule.engine.core.api.editorconfig.EditorConfigProperty;
import com.pinterest.ktlint.rule.engine.core.api.editorconfig.IndentSizeEditorConfigPropertyKt;
import com.pinterest.ktlint.rule.engine.core.api.editorconfig.IndentStyleEditorConfigPropertyKt;
import com.pinterest.ktlint.ruleset.standard.StandardRule;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.ec4j.core.model.PropertyType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.lang.ASTNode;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.PsiWhiteSpaceImpl;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@SinceKtlint.Container(value={@SinceKtlint(version="1.4", status=SinceKtlint.Status.EXPERIMENTAL), @SinceKtlint(version="1.8", status=SinceKtlint.Status.STABLE)})
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J]\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000e2K\u0010\u000f\u001aG\u0012\u0013\u0012\u00110\u0011\u00a2\u0006\f\b\u0012\u0012\b\b\u0013\u0012\u0004\b\b(\u0014\u0012\u0013\u0012\u00110\u0015\u00a2\u0006\f\b\u0012\u0012\b\b\u0013\u0012\u0004\b\b(\u0016\u0012\u0013\u0012\u00110\u0017\u00a2\u0006\f\b\u0012\u0012\b\b\u0013\u0012\u0004\b\b(\u0018\u0012\u0004\u0012\u00020\u00190\u0010H\u0016J]\u0010\u001a\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000e2K\u0010\u001b\u001aG\u0012\u0013\u0012\u00110\u0011\u00a2\u0006\f\b\u0012\u0012\b\b\u0013\u0012\u0004\b\b(\u0014\u0012\u0013\u0012\u00110\u0015\u00a2\u0006\f\b\u0012\u0012\b\b\u0013\u0012\u0004\b\b(\u0016\u0012\u0013\u0012\u00110\u0017\u00a2\u0006\f\b\u0012\u0012\b\b\u0013\u0012\u0004\b\b(\u0018\u0012\u0004\u0012\u00020\u00190\u0010H\u0002J\f\u0010\u001c\u001a\u00020\u0017*\u00020\u000eH\u0002J\f\u0010\u001d\u001a\u00020\u0017*\u00020\u000eH\u0002J\f\u0010\u001e\u001a\u00020\u0017*\u00020\u000eH\u0002J\f\u0010\u001f\u001a\u00020\u0017*\u00020\u000eH\u0002J]\u0010 \u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000e2K\u0010\u001b\u001aG\u0012\u0013\u0012\u00110\u0011\u00a2\u0006\f\b\u0012\u0012\b\b\u0013\u0012\u0004\b\b(\u0014\u0012\u0013\u0012\u00110\u0015\u00a2\u0006\f\b\u0012\u0012\b\b\u0013\u0012\u0004\b\b(\u0016\u0012\u0013\u0012\u00110\u0017\u00a2\u0006\f\b\u0012\u0012\b\b\u0013\u0012\u0004\b\b(\u0018\u0012\u0004\u0012\u00020\u00190\u0010H\u0002J\f\u0010!\u001a\u00020\t*\u00020\u000eH\u0002J\u0017\u0010\"\u001a\t\u0018\u00010\u000e\u00a2\u0006\u0002\b#2\u0006\u0010$\u001a\u00020\u0015H\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lcom/pinterest/ktlint/ruleset/standard/rules/WhenEntryBracing;", "Lcom/pinterest/ktlint/ruleset/standard/StandardRule;", "Lcom/pinterest/ktlint/rule/engine/core/api/RuleAutocorrectApproveHandler;", "Lcom/pinterest/ktlint/rule/engine/core/api/Rule$OfficialCodeStyle;", "<init>", "()V", "indentConfig", "Lcom/pinterest/ktlint/rule/engine/core/api/IndentConfig;", "beforeFirstNode", "", "editorConfig", "Lcom/pinterest/ktlint/rule/engine/core/api/editorconfig/EditorConfig;", "beforeVisitChildNodes", "node", "Lorg/jetbrains/kotlin/com/intellij/lang/ASTNode;", "emit", "Lkotlin/Function3;", "", "Lkotlin/ParameterName;", "name", "offset", "", "errorMessage", "", "canBeAutoCorrected", "Lcom/pinterest/ktlint/rule/engine/core/api/AutocorrectDecision;", "visitWhenStatement", "emitAndApprove", "hasAnyWhenEntryWithBlockAfterArrow", "hasBlockAfterArrow", "hasAnyWhenEntryWithMultilineBody", "hasMultilineBody", "addBracesToWhenEntry", "surroundWithBraces", "createBlockExpression", "Lorg/jetbrains/annotations/Nullable;", "whenEntry", "ktlint-ruleset-standard"})
@SourceDebugExtension(value={"SMAP\nWhenEntryBracing.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WhenEntryBracing.kt\ncom/pinterest/ktlint/ruleset/standard/rules/WhenEntryBracing\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 ASTNodeExtension.kt\ncom/pinterest/ktlint/rule/engine/core/api/ASTNodeExtensionKt\n+ 4 AutocorrectDecision.kt\ncom/pinterest/ktlint/rule/engine/core/api/AutocorrectDecisionKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,163:1\n1255#2,2:164\n1255#2,2:166\n1255#2,2:168\n1255#2,2:170\n1321#2:172\n1322#2:184\n297#3,8:173\n325#3:185\n319#3:186\n276#3:187\n325#3:188\n19#4:181\n18#4:182\n1#5:183\n*S KotlinDebug\n*F\n+ 1 WhenEntryBracing.kt\ncom/pinterest/ktlint/ruleset/standard/rules/WhenEntryBracing\n*L\n80#1:164,2\n87#1:166,2\n90#1:168,2\n97#1:170,2\n108#1:172\n108#1:184\n112#1:173,8\n140#1:185\n140#1:186\n141#1:187\n142#1:188\n118#1:181\n118#1:182\n118#1:183\n*E\n"})
public final class WhenEntryBracing
extends StandardRule
implements RuleAutocorrectApproveHandler,
Rule.OfficialCodeStyle {
    @NotNull
    private IndentConfig indentConfig;

    public WhenEntryBracing() {
        Object[] objectArray = new EditorConfigProperty[]{IndentSizeEditorConfigPropertyKt.getINDENT_SIZE_PROPERTY(), IndentStyleEditorConfigPropertyKt.getINDENT_STYLE_PROPERTY()};
        super("when-entry-bracing", null, SetsKt.setOf((Object[])objectArray), 2, null);
        this.indentConfig = IndentConfig.Companion.getDEFAULT_INDENT_CONFIG();
    }

    public void beforeFirstNode(@NotNull EditorConfig editorConfig) {
        Intrinsics.checkNotNullParameter((Object)editorConfig, (String)"editorConfig");
        this.indentConfig = new IndentConfig((PropertyType.IndentStyleValue)editorConfig.get(IndentStyleEditorConfigPropertyKt.getINDENT_STYLE_PROPERTY()), ((Number)editorConfig.get(IndentSizeEditorConfigPropertyKt.getINDENT_SIZE_PROPERTY())).intValue());
    }

    @Override
    public void beforeVisitChildNodes(@NotNull ASTNode node, @NotNull Function3<? super Integer, ? super String, ? super Boolean, ? extends AutocorrectDecision> emit) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter(emit, (String)"emit");
        if (Intrinsics.areEqual((Object)node.getElementType(), (Object)ElementType.INSTANCE.getWHEN())) {
            this.visitWhenStatement(node, emit);
        }
    }

    private final void visitWhenStatement(ASTNode node, Function3<? super Integer, ? super String, ? super Boolean, ? extends AutocorrectDecision> emitAndApprove) {
        if (this.hasAnyWhenEntryWithBlockAfterArrow(node) || this.hasAnyWhenEntryWithMultilineBody(node)) {
            this.addBracesToWhenEntry(node, emitAndApprove);
        }
    }

    private final boolean hasAnyWhenEntryWithBlockAfterArrow(ASTNode $this$hasAnyWhenEntryWithBlockAfterArrow) {
        boolean bl;
        block1: {
            Sequence $this$any$iv = ASTNodeExtensionKt.getChildren20((ASTNode)$this$hasAnyWhenEntryWithBlockAfterArrow);
            boolean $i$f$any = false;
            for (Object element$iv : $this$any$iv) {
                ASTNode it = (ASTNode)element$iv;
                boolean bl2 = false;
                if (!(Intrinsics.areEqual((Object)it.getElementType(), (Object)ElementType.INSTANCE.getWHEN_ENTRY()) && this.hasBlockAfterArrow(it))) continue;
                bl = true;
                break block1;
            }
            bl = false;
        }
        return bl;
    }

    private final boolean hasBlockAfterArrow(ASTNode $this$hasBlockAfterArrow) {
        boolean bl;
        block3: {
            if (!Intrinsics.areEqual((Object)$this$hasBlockAfterArrow.getElementType(), (Object)ElementType.INSTANCE.getWHEN_ENTRY())) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            ASTNode aSTNode = $this$hasBlockAfterArrow.findChildByType(ElementType.INSTANCE.getARROW());
            Sequence sequence = aSTNode != null ? PsiUtilsKt.siblings$default((ASTNode)aSTNode, (boolean)false, (int)1, null) : null;
            if (sequence == null) {
                sequence = SequencesKt.emptySequence();
            }
            Sequence $this$any$iv = sequence;
            boolean $i$f$any = false;
            for (Object element$iv : $this$any$iv) {
                ASTNode it = (ASTNode)element$iv;
                boolean bl2 = false;
                if (!Intrinsics.areEqual((Object)it.getElementType(), (Object)ElementType.INSTANCE.getBLOCK())) continue;
                bl = true;
                break block3;
            }
            bl = false;
        }
        return bl;
    }

    private final boolean hasAnyWhenEntryWithMultilineBody(ASTNode $this$hasAnyWhenEntryWithMultilineBody) {
        boolean bl;
        block1: {
            Sequence $this$any$iv = ASTNodeExtensionKt.getChildren20((ASTNode)$this$hasAnyWhenEntryWithMultilineBody);
            boolean $i$f$any = false;
            for (Object element$iv : $this$any$iv) {
                ASTNode it = (ASTNode)element$iv;
                boolean bl2 = false;
                if (!(Intrinsics.areEqual((Object)it.getElementType(), (Object)ElementType.INSTANCE.getWHEN_ENTRY()) && this.hasMultilineBody(it))) continue;
                bl = true;
                break block1;
            }
            bl = false;
        }
        return bl;
    }

    private final boolean hasMultilineBody(ASTNode $this$hasMultilineBody) {
        boolean bl;
        block3: {
            if (!Intrinsics.areEqual((Object)$this$hasMultilineBody.getElementType(), (Object)ElementType.INSTANCE.getWHEN_ENTRY())) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            ASTNode aSTNode = $this$hasMultilineBody.findChildByType(ElementType.INSTANCE.getARROW());
            Sequence sequence = aSTNode != null ? PsiUtilsKt.siblings$default((ASTNode)aSTNode, (boolean)false, (int)1, null) : null;
            if (sequence == null) {
                sequence = SequencesKt.emptySequence();
            }
            Sequence $this$any$iv = sequence;
            boolean $i$f$any = false;
            for (Object element$iv : $this$any$iv) {
                ASTNode it = (ASTNode)element$iv;
                boolean bl2 = false;
                if (!ASTNodeExtensionKt.isWhiteSpaceWithNewline20((ASTNode)it)) continue;
                bl = true;
                break block3;
            }
            bl = false;
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    private final void addBracesToWhenEntry(ASTNode node, Function3<? super Integer, ? super String, ? super Boolean, ? extends AutocorrectDecision> emitAndApprove) {
        Sequence $this$forEach$iv = SequencesKt.filter((Sequence)SequencesKt.filter((Sequence)ASTNodeExtensionKt.getChildren20((ASTNode)node), WhenEntryBracing::addBracesToWhenEntry$lambda$0), arg_0 -> WhenEntryBracing.addBracesToWhenEntry$lambda$1(this, arg_0));
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            void $this$ifAutocorrectAllowed$iv;
            ASTNode aSTNode;
            ASTNode aSTNode2;
            ASTNode arrow;
            block3: {
                ASTNode whenEntry = (ASTNode)element$iv;
                boolean bl = false;
                ASTNode aSTNode3 = whenEntry.findChildByType(ElementType.INSTANCE.getARROW());
                if (aSTNode3 == null) continue;
                arrow = aSTNode3;
                boolean bl2 = false;
                ASTNode $this$nextSibling$iv = arrow;
                boolean $i$f$nextSibling = false;
                for (ASTNode node$iv = $this$nextSibling$iv.getTreeNext(); node$iv != null; node$iv = node$iv.getTreeNext()) {
                    ASTNode it = node$iv;
                    boolean bl3 = false;
                    if (!(!ASTNodeExtensionKt.isWhiteSpace20((ASTNode)it))) continue;
                    aSTNode2 = node$iv;
                    break block3;
                }
                aSTNode2 = aSTNode = null;
            }
            if (aSTNode2 == null) {
                aSTNode = arrow;
            }
            ASTNode nonWhiteSpaceSibling = aSTNode;
            AutocorrectDecision autocorrectDecision = (AutocorrectDecision)emitAndApprove.invoke((Object)nonWhiteSpaceSibling.getStartOffset(), (Object)"Body of when entry should be surrounded by braces if any when entry body is surrounded by braces or has a multiline body", (Object)true);
            boolean $i$f$ifAutocorrectAllowed = false;
            void var13_14 = $this$ifAutocorrectAllowed$iv;
            Object it$iv = var13_14;
            boolean bl = false;
            Object object = $this$ifAutocorrectAllowed$iv == AutocorrectDecision.ALLOW_AUTOCORRECT ? var13_14 : null;
            if (object == null) continue;
            it$iv = object;
            boolean bl4 = false;
            boolean bl5 = false;
            this.surroundWithBraces(arrow);
        }
    }

    private final void surroundWithBraces(ASTNode $this$surroundWithBraces) {
        block2: {
            if (!Intrinsics.areEqual((Object)$this$surroundWithBraces.getElementType(), (Object)ElementType.INSTANCE.getARROW())) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            String whenEntryIndent = StringsKt.removePrefix((String)this.indentConfig.parentIndentOf($this$surroundWithBraces), (CharSequence)"\n");
            String whenEntry = whenEntryIndent + "true -> {" + this.indentConfig.childIndentOf($this$surroundWithBraces) + SequencesKt.joinToString$default((Sequence)SequencesKt.dropWhile((Sequence)PsiUtilsKt.siblings$default((ASTNode)$this$surroundWithBraces, (boolean)false, (int)1, null), WhenEntryBracing::surroundWithBraces$lambda$0), (CharSequence)"", null, null, (int)0, null, WhenEntryBracing::surroundWithBraces$lambda$1, (int)30, null) + '\n' + whenEntryIndent + '}';
            ASTNode blockExpression = this.createBlockExpression(whenEntry);
            ASTNode $this$parent$iv = $this$surroundWithBraces;
            boolean $i$f$getParent = false;
            ASTNode aSTNode = $this$parent$iv.getTreeParent();
            if (aSTNode != null) {
                ASTNode $this$nextSibling20$iv = $this$surroundWithBraces;
                boolean $i$f$getNextSibling20 = false;
                ASTNode aSTNode2 = $this$nextSibling20$iv.getTreeNext();
                Intrinsics.checkNotNull((Object)aSTNode2);
                aSTNode.removeRange(aSTNode2, null);
            }
            ASTNode $this$prevSibling20$iv = $this$surroundWithBraces;
            boolean $i$f$getPrevSibling20 = false;
            ASTNode aSTNode3 = $this$prevSibling20$iv.getTreePrev();
            Intrinsics.checkNotNull((Object)aSTNode3);
            $this$prevSibling20$iv = aSTNode3;
            $i$f$getParent = false;
            ASTNode aSTNode4 = $this$parent$iv.getTreeParent();
            if (aSTNode4 == null) break block2;
            ASTNode $this$surroundWithBraces_u24lambda_u242 = aSTNode4;
            boolean bl = false;
            $this$surroundWithBraces_u24lambda_u242.addChild((ASTNode)new PsiWhiteSpaceImpl((CharSequence)" "), null);
            ASTNode aSTNode5 = blockExpression;
            Intrinsics.checkNotNull((Object)aSTNode5);
            $this$surroundWithBraces_u24lambda_u242.addChild(aSTNode5, null);
        }
    }

    private final ASTNode createBlockExpression(String whenEntry) {
        ASTNode aSTNode;
        ASTNode aSTNode2;
        ASTNode aSTNode3 = KtlintKotlinCompiler.INSTANCE.createASTNodeFromText(StringsKt.trimMargin$default((String)("\n                |when {\n                |" + whenEntry + "\n                |}\n                "), null, (int)1, null));
        return aSTNode3 != null && (aSTNode2 = aSTNode3.findChildByType(ElementType.INSTANCE.getWHEN())) != null && (aSTNode = aSTNode2.findChildByType(ElementType.INSTANCE.getWHEN_ENTRY())) != null ? aSTNode.findChildByType(ElementType.INSTANCE.getBLOCK()) : null;
    }

    private static final boolean addBracesToWhenEntry$lambda$0(ASTNode it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Intrinsics.areEqual((Object)it.getElementType(), (Object)ElementType.INSTANCE.getWHEN_ENTRY());
    }

    private static final boolean addBracesToWhenEntry$lambda$1(WhenEntryBracing this$0, ASTNode it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return !this$0.hasBlockAfterArrow(it);
    }

    private static final boolean surroundWithBraces$lambda$0(ASTNode it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return ASTNodeExtensionKt.isWhiteSpace20((ASTNode)it);
    }

    private static final CharSequence surroundWithBraces$lambda$1(ASTNode it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        String string = it.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        return string;
    }
}

