/*
 * Decompiled with CFR 0.152.
 */
package com.pinterest.ktlint.test;

import com.google.common.jimfs.Configuration;
import com.google.common.jimfs.Jimfs;
import com.pinterest.ktlint.test.KtlintTestFileSystemKt;
import java.nio.file.FileSystem;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.util.UtilKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\t\n\u0002\u0010\u0011\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0011\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0003J \u0010\u0013\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u00032\u0006\u0010\u0012\u001a\u00020\u00032\b\b\u0002\u0010\u0015\u001a\u00020\u0003J\u001e\u0010\u0016\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u00032\u0006\u0010\u0017\u001a\u00020\u00032\u0006\u0010\u0012\u001a\u00020\u0003J\u0016\u0010\u0016\u001a\u00020\u00112\u0006\u0010\u0018\u001a\u00020\u00032\u0006\u0010\u0012\u001a\u00020\u0003J-\u0010\u0019\u001a\n \u000e*\u0004\u0018\u00010\r0\r2\u0016\u0010\u001a\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00030\u001b\"\u0004\u0018\u00010\u0003H\u0002\u00a2\u0006\u0002\u0010\u001cJ\u000e\u0010\u001d\u001a\u00020\u00032\u0006\u0010\u001e\u001a\u00020\u0003J\u0012\u0010\u001f\u001a\u00020\r2\n\b\u0002\u0010 \u001a\u0004\u0018\u00010\u0003J\u0006\u0010!\u001a\u00020\u0011R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082D\u00a2\u0006\u0002\n\u0000R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0016\u0010\f\u001a\n \u000e*\u0004\u0018\u00010\r0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lcom/pinterest/ktlint/test/KtlintTestFileSystem;", "", "rootDirectory", "", "<init>", "(Ljava/lang/String;)V", "useNativeFileSystem", "", "fileSystem", "Ljava/nio/file/FileSystem;", "getFileSystem", "()Ljava/nio/file/FileSystem;", "fileSystemRootPath", "Ljava/nio/file/Path;", "kotlin.jvm.PlatformType", "rootDirectoryPathString", "writeRootEditorConfigFile", "", "content", "writeEditorConfigFile", "relativeDirectoryToRoot", "editorConfigFileName", "writeFile", "fileName", "filePath", "operatingSystemPath", "segments", "", "([Ljava/lang/String;)Ljava/nio/file/Path;", "unixPathStringRelativeToRootDirectoryOfFileSystem", "nativePath", "resolve", "pathRelativeToRootDirectory", "close", "ktlint-test"})
@SourceDebugExtension(value={"SMAP\nKtlintTestFileSystem.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KtlintTestFileSystem.kt\ncom/pinterest/ktlint/test/KtlintTestFileSystem\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,128:1\n774#2:129\n865#2,2:130\n*S KotlinDebug\n*F\n+ 1 KtlintTestFileSystem.kt\ncom/pinterest/ktlint/test/KtlintTestFileSystem\n*L\n97#1:129\n97#1:130,2\n*E\n"})
public final class KtlintTestFileSystem {
    @NotNull
    private final String rootDirectory;
    private final boolean useNativeFileSystem;
    @NotNull
    private final FileSystem fileSystem;
    private final Path fileSystemRootPath;
    @NotNull
    private final String rootDirectoryPathString;

    public KtlintTestFileSystem(@NotNull String rootDirectory) {
        String[] stringArray;
        String[] stringArray2;
        Intrinsics.checkNotNullParameter((Object)rootDirectory, (String)"rootDirectory");
        this.rootDirectory = rootDirectory;
        this.useNativeFileSystem = true;
        KtlintTestFileSystem ktlintTestFileSystem = this;
        if (this.useNativeFileSystem) {
            String[] stringArray3 = Jimfs.newFileSystem((Configuration)Configuration.forCurrentPlatform());
            Intrinsics.checkNotNull((Object)stringArray3);
            stringArray2 = stringArray3;
        } else {
            String[] stringArray4 = stringArray = Jimfs.newFileSystem((Configuration)Configuration.windows());
            KtlintTestFileSystem ktlintTestFileSystem2 = ktlintTestFileSystem;
            boolean bl = false;
            KtlintTestFileSystemKt.access$getLOGGER$p().warn(() -> KtlintTestFileSystem.fileSystem$lambda$0$0(this));
            System.setProperty("os.name", "windows");
            ktlintTestFileSystem = ktlintTestFileSystem2;
            String[] stringArray5 = stringArray;
            Intrinsics.checkNotNull((Object)stringArray5);
            stringArray2 = stringArray5;
        }
        ktlintTestFileSystem.fileSystem = stringArray2;
        Iterable<Path> iterable = this.fileSystem.getRootDirectories();
        Intrinsics.checkNotNullExpressionValue(iterable, (String)"getRootDirectories(...)");
        this.fileSystemRootPath = (Path)CollectionsKt.first(iterable);
        stringArray = new String[]{this.rootDirectory};
        Path path = this.operatingSystemPath(stringArray);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"operatingSystemPath(...)");
        this.rootDirectoryPathString = ((Object)path).toString();
    }

    public /* synthetic */ KtlintTestFileSystem(String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            string = "/project";
        }
        this(string);
    }

    @NotNull
    public final FileSystem getFileSystem() {
        return this.fileSystem;
    }

    public final void writeRootEditorConfigFile(@NotNull String content) {
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        KtlintTestFileSystem.writeEditorConfigFile$default(this, "", content, null, 4, null);
    }

    public final void writeEditorConfigFile(@NotNull String relativeDirectoryToRoot, @NotNull String content, @NotNull String editorConfigFileName) {
        Intrinsics.checkNotNullParameter((Object)relativeDirectoryToRoot, (String)"relativeDirectoryToRoot");
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        Intrinsics.checkNotNullParameter((Object)editorConfigFileName, (String)"editorConfigFileName");
        this.writeFile(relativeDirectoryToRoot, editorConfigFileName, content);
    }

    public static /* synthetic */ void writeEditorConfigFile$default(KtlintTestFileSystem ktlintTestFileSystem, String string, String string2, String string3, int n, Object object) {
        if ((n & 4) != 0) {
            string3 = ".editorconfig";
        }
        ktlintTestFileSystem.writeEditorConfigFile(string, string2, string3);
    }

    public final void writeFile(@NotNull String relativeDirectoryToRoot, @NotNull String fileName, @NotNull String content) {
        Intrinsics.checkNotNullParameter((Object)relativeDirectoryToRoot, (String)"relativeDirectoryToRoot");
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        Object object = new String[]{this.rootDirectory, relativeDirectoryToRoot};
        Files.createDirectories(this.operatingSystemPath((String[])object), new FileAttribute[0]);
        object = new String[]{this.rootDirectory, relativeDirectoryToRoot, fileName};
        Path path = this.operatingSystemPath((String[])object);
        object = content;
        byte[] byArray = ((String)object).getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        Files.write(path, byArray, new OpenOption[0]);
    }

    public final void writeFile(@NotNull String filePath, @NotNull String content) {
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        String[] stringArray = new String[]{filePath};
        Path path = this.operatingSystemPath(stringArray);
        boolean bl = false;
        Files.createDirectories(path.getParent(), new FileAttribute[0]);
        byte[] byArray = content.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        Files.write(path, byArray, new OpenOption[0]);
    }

    /*
     * WARNING - void declaration
     */
    private final Path operatingSystemPath(String ... segments) {
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = ArraysKt.filterNotNull((Object[])segments);
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            String it = (String)element$iv$iv;
            boolean bl = false;
            boolean bl2 = !StringsKt.isBlank((CharSequence)it);
            if (!bl2) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable iterable2 = CollectionsKt.toList((Iterable)((List)destination$iv$iv));
        String string = this.fileSystem.getSeparator();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getSeparator(...)");
        String path = CollectionsKt.joinToString$default((Iterable)iterable2, (CharSequence)string, null, null, (int)0, null, arg_0 -> KtlintTestFileSystem.operatingSystemPath$lambda$1(this, arg_0), (int)30, null);
        boolean bl = false;
        return this.fileSystemRootPath.resolve(path);
    }

    @NotNull
    public final String unixPathStringRelativeToRootDirectoryOfFileSystem(@NotNull String nativePath) {
        Intrinsics.checkNotNullParameter((Object)nativePath, (String)"nativePath");
        String string = this.fileSystem.getSeparator();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getSeparator(...)");
        String string2 = StringsKt.removePrefix((String)nativePath, (CharSequence)UtilKt.suffixIfNot((String)this.rootDirectoryPathString, (String)string));
        String string3 = this.fileSystem.getSeparator();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getSeparator(...)");
        return StringsKt.replace$default((String)string2, (String)string3, (String)"/", (boolean)false, (int)4, null);
    }

    @NotNull
    public final Path resolve(@Nullable String pathRelativeToRootDirectory) {
        String[] stringArray = new String[]{this.rootDirectory, pathRelativeToRootDirectory};
        Path path = this.operatingSystemPath(stringArray);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"operatingSystemPath(...)");
        return path;
    }

    public static /* synthetic */ Path resolve$default(KtlintTestFileSystem ktlintTestFileSystem, String string, int n, Object object) {
        if ((n & 1) != 0) {
            string = null;
        }
        return ktlintTestFileSystem.resolve(string);
    }

    public final void close() {
        this.fileSystem.close();
    }

    private static final Object fileSystem$lambda$0$0(KtlintTestFileSystem this$0) {
        return StringsKt.trimIndent((String)("\n                        " + Reflection.getOrCreateKotlinClass(this$0.getClass()).getSimpleName() + " has been overridden and set to Windows Platform. This should only be used for testing on\n                        the local machine running on a different OS. Also system property 'os.name' is set to 'windows' as some classes use\n                        this property to detect the Windows OS. Unit tests annotated with '@DisabledOnOs(OS.WINDOWS)' will still be executed\n                        and likely will fail.\n                        "));
    }

    private static final CharSequence operatingSystemPath$lambda$1(KtlintTestFileSystem this$0, String segment) {
        Intrinsics.checkNotNullParameter((Object)segment, (String)"segment");
        String string = this$0.fileSystem.getSeparator();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getSeparator(...)");
        String string2 = StringsKt.replace$default((String)segment, (String)"/", (String)string, (boolean)false, (int)4, null);
        String string3 = this$0.fileSystem.getSeparator();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getSeparator(...)");
        String string4 = StringsKt.removePrefix((String)string2, (CharSequence)string3);
        String string5 = this$0.fileSystem.getSeparator();
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"getSeparator(...)");
        return StringsKt.removePrefix((String)string4, (CharSequence)string5);
    }

    public KtlintTestFileSystem() {
        this(null, 1, null);
    }
}

