/*
 * Decompiled with CFR 0.152.
 */
package com.profesorfalken.jsensors.manager.unix;

import com.profesorfalken.jsensors.manager.SensorsManager;
import com.profesorfalken.jsensors.manager.unix.jna.CChip;
import com.profesorfalken.jsensors.manager.unix.jna.CFeature;
import com.profesorfalken.jsensors.manager.unix.jna.CSensors;
import com.profesorfalken.jsensors.manager.unix.jna.CSubFeature;
import com.profesorfalken.jsensors.util.SensorsUtils;
import com.sun.jna.Native;
import com.sun.jna.ptr.DoubleByReference;
import com.sun.jna.ptr.IntByReference;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UnixSensorsManager
extends SensorsManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(UnixSensorsManager.class);
    private static final String LINE_BREAK = "\n";
    private final StringBuilder sensorsData = new StringBuilder();
    private final StringBuilder sensorsDebugData = new StringBuilder();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getSensorsData() {
        CSensors cSensors = this.loadDynamicLibrary();
        if (cSensors == null) {
            LOGGER.error("Could not load sensors dynamic library");
            return "";
        }
        int init = UnixSensorsManager.initCSensors(cSensors);
        if (init != 0) {
            LOGGER.error("Cannot initialize sensors");
            return "";
        }
        String normalizedData = "";
        try {
            normalizedData = this.normalizeSensorsData(cSensors);
        }
        finally {
            cSensors.sensors_cleanup();
        }
        return normalizedData;
    }

    private CSensors loadDynamicLibrary() {
        Object jnaProxy;
        try {
            jnaProxy = Native.loadLibrary((String)"sensors", CSensors.class);
        }
        catch (UnsatisfiedLinkError err) {
            LOGGER.info("Cannot find library in system, using embedded one");
            try {
                String libPath = SensorsUtils.generateLibTmpPath("/lib/linux/", "libsensors.so.4.4.0");
                jnaProxy = Native.loadLibrary((String)libPath, CSensors.class);
                new File(libPath).delete();
            }
            catch (UnsatisfiedLinkError err1) {
                jnaProxy = null;
                LOGGER.error("Cannot load sensors dinamic library", (Throwable)err1);
            }
        }
        return (CSensors)jnaProxy;
    }

    private static int initCSensors(CSensors cSensors) {
        return cSensors.sensors_init(null);
    }

    private void addData(String data) {
        this.addData(data, true);
    }

    private void addData(String data, boolean newLine) {
        String endLine = newLine ? LINE_BREAK : "";
        this.sensorsData.append(data).append(endLine);
        this.sensorsDebugData.append(data).append(endLine);
    }

    private void addDebugData(String debugData) {
        this.sensorsDebugData.append(debugData).append(LINE_BREAK);
    }

    private String normalizeSensorsData(CSensors cSensors) {
        List<CChip> chips = UnixSensorsManager.detectedChips(cSensors);
        for (CChip chip : chips) {
            this.addData("[COMPONENT]");
            this.addDebugData(String.format("Type: %d", chip.bus.type));
            this.addDebugData(String.format("Address: %d", chip.addr));
            this.addDebugData(String.format("Path: %s", chip.path));
            this.addDebugData(String.format("Prefix: %s", chip.prefix));
            if (chip.bus != null) {
                switch (chip.bus.type) {
                    case 1: {
                        this.addData("CPU");
                        break;
                    }
                    case 2: {
                        this.addData("GPU");
                        break;
                    }
                    case 4: 
                    case 5: {
                        this.addData("DISK");
                        break;
                    }
                    default: {
                        this.addData("UNKNOWN");
                    }
                }
            }
            this.addData(String.format("Label: %s", cSensors.sensors_get_adapter_name(chip.bus)));
            List<CFeature> features = UnixSensorsManager.features(cSensors, chip);
            this.addFeatures(cSensors, chip, features);
        }
        if (this.debugMode) {
            LOGGER.info(this.sensorsDebugData.toString());
        }
        return this.sensorsData.toString();
    }

    private void addFeatures(CSensors cSensors, CChip chip, List<CFeature> features) {
        for (CFeature feature : features) {
            this.addDebugData(String.format("Feature type: %d", feature.type));
            this.addDebugData(String.format("Feature name: %s", feature.name));
            this.addDebugData(String.format("Feature label: %s", cSensors.sensors_get_label(chip, feature)));
            if (feature.name.startsWith("temp")) {
                this.addData(String.format("Temp %s:", cSensors.sensors_get_label(chip, feature)), false);
            } else if (feature.name.startsWith("fan")) {
                this.addData(String.format("Fan %s:", cSensors.sensors_get_label(chip, feature)), false);
            }
            List<CSubFeature> subFeatures = UnixSensorsManager.subFeatures(cSensors, chip, feature);
            this.addSubFeatures(cSensors, chip, subFeatures);
        }
    }

    private void addSubFeatures(CSensors cSensors, CChip chip, List<CSubFeature> subFeatures) {
        for (CSubFeature subFeature : subFeatures) {
            this.addDebugData(String.format("SubFeature type: %d", subFeature.type));
            this.addDebugData(String.format("SubFeature name: %s", subFeature.name));
            double value = 0.0;
            DoubleByReference pValue = new DoubleByReference(value);
            if (cSensors.sensors_get_value(chip, subFeature.number, pValue) == 0) {
                this.addDebugData(String.format("SubFeature value: %s", pValue.getValue()));
                if (!subFeature.name.endsWith("_input")) continue;
                this.addData(String.format("%s", pValue.getValue()));
                break;
            }
            this.addData("Could not retrieve value");
        }
    }

    private static List<CChip> detectedChips(CSensors cSensors) {
        CChip foundChip;
        ArrayList<CChip> detectedChips = new ArrayList<CChip>();
        int numSensor = 0;
        while ((foundChip = cSensors.sensors_get_detected_chips(null, new IntByReference(numSensor))) != null) {
            detectedChips.add(foundChip);
            ++numSensor;
        }
        return detectedChips;
    }

    private static List<CFeature> features(CSensors cSensors, CChip chip) {
        CFeature foundFeature;
        ArrayList<CFeature> features = new ArrayList<CFeature>();
        int numFeature = 0;
        while ((foundFeature = cSensors.sensors_get_features(chip, new IntByReference(numFeature))) != null) {
            features.add(foundFeature);
            ++numFeature;
        }
        return features;
    }

    private static List<CSubFeature> subFeatures(CSensors cSensors, CChip chip, CFeature feature) {
        CSubFeature foundSubFeature;
        ArrayList<CSubFeature> subFeatures = new ArrayList<CSubFeature>();
        int numSubFeature = 0;
        while ((foundSubFeature = cSensors.sensors_get_all_subfeatures(chip, feature, new IntByReference(numSubFeature))) != null) {
            subFeatures.add(foundSubFeature);
            ++numSubFeature;
        }
        return subFeatures;
    }
}

