/*
 * Decompiled with CFR 0.152.
 */
package com.profesorfalken.jsensors.manager.windows.powershell;

import com.profesorfalken.jpowershell.PowerShell;
import com.profesorfalken.jpowershell.PowerShellNotAvailableException;
import com.profesorfalken.jsensors.manager.windows.powershell.PowerShellScriptHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PowerShellOperations {
    private static final Logger LOGGER = LoggerFactory.getLogger(PowerShellOperations.class);

    private PowerShellOperations() {
    }

    public static boolean isAdministrator() {
        String command = "([Security.Principal.WindowsPrincipal] [Security.Principal.WindowsIdentity]::GetCurrent()).IsInRole([Security.Principal.WindowsBuiltInRole] \"Administrator\")";
        return "true".equalsIgnoreCase(PowerShell.executeSingleCommand((String)command).getCommandOutput());
    }

    public static String getRawSensorsData() {
        PowerShell powershell = null;
        String rawData = null;
        try {
            powershell = PowerShell.openSession();
            rawData = powershell.executeScript(PowerShellScriptHelper.generateScript()).getCommandOutput();
        }
        catch (PowerShellNotAvailableException ex) {
            LOGGER.error("Cannot find PowerShell in your system. Please install it", (Throwable)ex);
        }
        finally {
            if (powershell != null) {
                powershell.close();
            }
        }
        return rawData;
    }
}

