/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.text.StrSubstitutor;

public enum BicValidationResult {
    OK("The BIC code is valid"),
    INVALID_LENGTH("The BIC code must contain at least 8 characters with the institution (4), country (2) and location code (2)"),
    INVALID_INSTITUTION_LENGTH("The institution code must contain 4 characters and ${length} were found in ${found}"),
    INVALID_COUNTRY_LENGTH("The country code must contain 2 characters and ${length} were found in ${found}"),
    INVALID_LOCATION_LENGTH("The location code must contain 2 characters and ${length} were found in ${found}"),
    INVALID_BRANCH_LENGTH("The branch code must contain 3 characters and ${length} were found in ${found}"),
    INVALID_INSTITUTION_CHARSET("The institution code can only contain uppercase letters and ${found} was found"),
    INVALID_COUNTRY("Invalid country code ${found}"),
    INVALID_LOCATION_CHARSET("The location code can only contain uppercase letters or digits and ${found} was found"),
    INVALID_BRANCH_CHARSET("The branch code can only contain uppercase letters or digits and ${found} was found");

    private final String message;
    private final Map<String, String> vars = new HashMap<String, String>();

    private BicValidationResult(String message) {
        this.message = message;
    }

    public String message() {
        StrSubstitutor sub = new StrSubstitutor(this.vars);
        return sub.replace(this.message);
    }

    void setFound(String found) {
        this.vars.put("found", found);
        if (found != null) {
            this.vars.put("length", String.valueOf(found.length()));
        }
    }

    private Map<String, String> vars() {
        return this.vars;
    }
}

