/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model;

import com.prowidesoftware.deprecation.DeprecationUtils;
import com.prowidesoftware.swift.model.BbanStructureDTO;
import com.prowidesoftware.swift.model.BbanStructureValidations;
import com.prowidesoftware.swift.model.IbanValidationResult;
import com.prowidesoftware.swift.model.IbanValidationUtils;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang3.StringUtils;

public class IBAN {
    static final int COUNTRY_CODE_LENGTH = 2;
    static final int CHECK_DIGIT_LENGTH = 2;
    private static final transient Logger log = Logger.getLogger(IBAN.class.getName());
    private static final int COUNTRY_CODE_INDEX = 0;
    private static final int CHECK_DIGIT_INDEX = 2;
    private static final int BBAN_INDEX = 4;
    private static final String INVALIDA_IBAN_LENGTH = "Invalid IBAN length in";
    @Deprecated
    private String invalidCause = null;
    private String iban;

    public IBAN(String iban) {
        this.iban = iban;
    }

    public static String getBban(String iban) throws IndexOutOfBoundsException {
        return iban.substring(4);
    }

    public static String getCheckDigits(String iban) throws IndexOutOfBoundsException {
        return iban.substring(2, 4);
    }

    public static String getCountryCode(String iban) throws IndexOutOfBoundsException {
        return iban.substring(0, 2);
    }

    public String getIban() {
        return this.iban;
    }

    public void setIban(String iban) {
        this.iban = iban;
    }

    public boolean isValid() {
        IbanValidationResult result = this.validate();
        if (result == IbanValidationResult.OK) {
            return true;
        }
        this.invalidCause = result.message();
        return false;
    }

    public IbanValidationResult validate() {
        if (this.iban == null) {
            return IbanValidationResult.IBAN_IS_NULL;
        }
        if (this.iban.length() == 0) {
            return IbanValidationResult.IBAN_IS_EMPTY;
        }
        IbanValidationResult result = null;
        try {
            String bban;
            String code = this.removeNonAlpha(this.iban);
            result = IbanValidationUtils.validateCountryCode(code);
            if (result == null) {
                result = IbanValidationUtils.validateCheckDigitPresence(code);
            }
            if (result == null) {
                result = IbanValidationUtils.validateBbanPresence(code);
            }
            if (result == null && (result = IbanValidationUtils.validateBbanMaxLength(bban = IBAN.getBban(code))) == null) {
                String country = IBAN.getCountryCode(code);
                BbanStructureDTO structure = BbanStructureValidations.getInstance().forCountry(country);
                if (structure == null) {
                    result = IbanValidationResult.MISSING_BBAN_CONFIGURATION;
                    result.setFound(country);
                } else {
                    result = IbanValidationUtils.validateBban(bban, structure);
                }
            }
            if (result == null) {
                result = IbanValidationUtils.validateCharacters(code);
            }
            if (result == null) {
                result = IbanValidationUtils.validateCheckDigit(code);
            }
        }
        catch (RuntimeException e) {
            return IbanValidationResult.UNKNOWN;
        }
        if (result != null) {
            return result;
        }
        return IbanValidationResult.OK;
    }

    public String translateChars(StringBuilder bban) {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < bban.length(); ++i) {
            char c = bban.charAt(i);
            if (Character.isLetter(c)) {
                result.append(Character.getNumericValue(c));
                continue;
            }
            result.append(c);
        }
        return result.toString();
    }

    public String removeNonAlpha(String iban) {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < iban.length(); ++i) {
            char c = iban.charAt(i);
            if (!Character.isLetter(c) && !Character.isDigit(c)) continue;
            result.append(c);
        }
        return result.toString();
    }

    @Deprecated
    public String getInvalidCause() {
        DeprecationUtils.phase3(this.getClass(), "getInvalidCause()", "Use the validate() method to get a detailed result of the validation problem found");
        return this.invalidCause;
    }

    public String getBban() {
        if (StringUtils.isNotEmpty((CharSequence)this.iban)) {
            try {
                return IBAN.getBban(this.iban);
            }
            catch (IndexOutOfBoundsException e) {
                log.log(Level.FINER, INVALIDA_IBAN_LENGTH + this.iban, e);
            }
        }
        return null;
    }

    public String getCheckDigits() {
        if (StringUtils.isNotEmpty((CharSequence)this.iban)) {
            try {
                return IBAN.getCheckDigits(this.iban);
            }
            catch (IndexOutOfBoundsException e) {
                log.log(Level.FINER, INVALIDA_IBAN_LENGTH + this.iban, e);
            }
        }
        return null;
    }

    public String getCountryCode() {
        if (StringUtils.isNotEmpty((CharSequence)this.iban)) {
            try {
                return IBAN.getCountryCode(this.iban);
            }
            catch (IndexOutOfBoundsException e) {
                log.log(Level.FINER, INVALIDA_IBAN_LENGTH + this.iban, e);
            }
        }
        return null;
    }
}

