/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.field;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.prowidesoftware.swift.model.SwiftMessage;
import com.prowidesoftware.swift.model.SwiftTagListBlock;
import com.prowidesoftware.swift.model.Tag;
import com.prowidesoftware.swift.model.field.AmountContainer;
import com.prowidesoftware.swift.model.field.AmountResolver;
import com.prowidesoftware.swift.model.field.Field;
import com.prowidesoftware.swift.model.field.SwiftParseUtils;
import com.prowidesoftware.swift.utils.SwiftFormatUtils;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class Field37V
extends Field
implements Serializable,
AmountContainer {
    public static final int SRU = 2020;
    private static final long serialVersionUID = 1L;
    public static final String NAME = "37V";
    public static final String F_37V = "37V";
    public static final String PARSER_PATTERN = "SN";
    public static final String COMPONENTS_PATTERN = "SN";
    public static final Integer SIGN = 1;
    public static final Integer RATE = 2;

    public Field37V() {
        super(2);
    }

    public Field37V(String value) {
        super(value);
    }

    public Field37V(Tag tag) {
        this();
        if (tag == null) {
            throw new IllegalArgumentException("tag cannot be null.");
        }
        if (!StringUtils.equals((CharSequence)tag.getName(), (CharSequence)"37V")) {
            throw new IllegalArgumentException("cannot create field 37V from tag " + tag.getName() + ", tagname must match the name of the field.");
        }
        this.parse(tag.getValue());
    }

    public static Field37V newInstance(Field37V source) {
        Field37V cp = new Field37V();
        cp.setComponents(new ArrayList<String>(source.getComponents()));
        return cp;
    }

    public static Tag tag(String value) {
        return new Tag("37V", value);
    }

    public static Tag emptyTag() {
        return new Tag("37V", "");
    }

    @Override
    public void parse(String value) {
        this.init(2);
        this.setComponent1(SwiftParseUtils.getAlphaPrefix(value));
        this.setComponent2(SwiftParseUtils.getNumericSuffix(value));
    }

    @Override
    public String getValue() {
        StringBuilder result = new StringBuilder();
        result.append(this.joinComponents());
        return result.toString();
    }

    @Override
    public String getValueDisplay(int component, Locale locale) {
        if (component < 1 || component > 2) {
            throw new IllegalArgumentException("invalid component number " + component + " for field 37V");
        }
        if (component == 1) {
            return this.getComponent(1);
        }
        if (component == 2) {
            NumberFormat f = NumberFormat.getNumberInstance(this.notNull(locale));
            f.setMaximumFractionDigits(13);
            Number n = this.getComponent2AsNumber();
            if (n != null) {
                return f.format(n);
            }
        }
        return null;
    }

    @Override
    public final String componentsPattern() {
        return "SN";
    }

    @Override
    public final String parserPattern() {
        return "SN";
    }

    @Override
    public final String validatorPattern() {
        return "[<N>]<AMOUNT>12";
    }

    @Override
    public boolean isOptional(int component) {
        return component == 1;
    }

    @Override
    public boolean isGeneric() {
        return false;
    }

    @Override
    public int componentsSize() {
        return 2;
    }

    @Override
    protected List<String> getComponentLabels() {
        ArrayList<String> result = new ArrayList<String>();
        result.add("Sign");
        result.add("Rate");
        return result;
    }

    @Override
    protected Map<Integer, String> getComponentMap() {
        HashMap<Integer, String> result = new HashMap<Integer, String>();
        result.put(1, "sign");
        result.put(2, "rate");
        return result;
    }

    public String getComponent1() {
        return this.getComponent(1);
    }

    public String getSign() {
        return this.getComponent(1);
    }

    public String getComponent2() {
        return this.getComponent(2);
    }

    public Number getComponent2AsNumber() {
        return SwiftFormatUtils.getNumber(this.getComponent(2));
    }

    public String getRate() {
        return this.getComponent(2);
    }

    public Number getRateAsNumber() {
        return SwiftFormatUtils.getNumber(this.getComponent(2));
    }

    public List<BigDecimal> amounts() {
        return AmountResolver.amounts(this);
    }

    @Override
    public BigDecimal amount() {
        return AmountResolver.amount(this);
    }

    public Field37V setComponent1(String component1) {
        this.setComponent(1, component1);
        return this;
    }

    public Field37V setSign(String component1) {
        this.setComponent(1, component1);
        return this;
    }

    public Field37V setComponent2(String component2) {
        this.setComponent(2, component2);
        return this;
    }

    public Field37V setComponent2(Number component2) {
        this.setComponent(2, SwiftFormatUtils.getNumber(component2));
        return this;
    }

    public Field37V setRate(String component2) {
        this.setComponent(2, component2);
        return this;
    }

    public Field37V setRate(Number component2) {
        this.setComponent2(component2);
        return this;
    }

    @Override
    public String getName() {
        return "37V";
    }

    public static Field37V get(SwiftTagListBlock block) {
        if (block == null || block.isEmpty()) {
            return null;
        }
        Tag t = block.getTagByName("37V");
        if (t == null) {
            return null;
        }
        return new Field37V(t);
    }

    public static Field37V get(SwiftMessage msg) {
        if (msg == null || msg.getBlock4() == null || msg.getBlock4().isEmpty()) {
            return null;
        }
        return Field37V.get(msg.getBlock4());
    }

    public static List<Field37V> getAll(SwiftMessage msg) {
        if (msg == null || msg.getBlock4() == null || msg.getBlock4().isEmpty()) {
            return Collections.emptyList();
        }
        return Field37V.getAll(msg.getBlock4());
    }

    public static List<Field37V> getAll(SwiftTagListBlock block) {
        if (block == null || block.isEmpty()) {
            return Collections.emptyList();
        }
        Tag[] arr = block.getTagsByName("37V");
        if (arr != null && arr.length > 0) {
            ArrayList<Field37V> result = new ArrayList<Field37V>(arr.length);
            for (Tag f : arr) {
                result.add(new Field37V(f));
            }
            return result;
        }
        return Collections.emptyList();
    }

    public static Field37V fromJson(String json) {
        Field37V field = new Field37V();
        JsonParser parser = new JsonParser();
        JsonObject jsonObject = (JsonObject)parser.parse(json);
        if (jsonObject.get("sign") != null) {
            field.setComponent1(jsonObject.get("sign").getAsString());
        }
        if (jsonObject.get("rate") != null) {
            field.setComponent2(jsonObject.get("rate").getAsString());
        }
        return field;
    }
}

