/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.field;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.prowidesoftware.swift.model.SwiftMessage;
import com.prowidesoftware.swift.model.SwiftTagListBlock;
import com.prowidesoftware.swift.model.Tag;
import com.prowidesoftware.swift.model.field.Field;
import com.prowidesoftware.swift.model.field.GenericField;
import com.prowidesoftware.swift.model.field.MultiLineField;
import com.prowidesoftware.swift.model.field.SwiftParseUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class Field70C
extends Field
implements Serializable,
GenericField,
MultiLineField {
    public static final int SRU = 2020;
    private static final long serialVersionUID = 1L;
    public static final String NAME = "70C";
    public static final String F_70C = "70C";
    public static final String PARSER_PATTERN = ":S//S[$S]0-3";
    public static final String COMPONENTS_PATTERN = "SSSSS";
    public static final Integer QUALIFIER = 1;
    public static final Integer NARRATIVE = 2;
    public static final Integer CONDITIONAL_QUALIFIER = 2;

    public Field70C() {
        super(5);
    }

    public Field70C(String value) {
        super(value);
    }

    public Field70C(Tag tag) {
        this();
        if (tag == null) {
            throw new IllegalArgumentException("tag cannot be null.");
        }
        if (!StringUtils.equals((CharSequence)tag.getName(), (CharSequence)"70C")) {
            throw new IllegalArgumentException("cannot create field 70C from tag " + tag.getName() + ", tagname must match the name of the field.");
        }
        this.parse(tag.getValue());
    }

    public static Field70C newInstance(Field70C source) {
        Field70C cp = new Field70C();
        cp.setComponents(new ArrayList<String>(source.getComponents()));
        return cp;
    }

    public static Tag tag(String value) {
        return new Tag("70C", value);
    }

    public static Tag emptyTag() {
        return new Tag("70C", "");
    }

    @Override
    public void parse(String value) {
        this.init(5);
        List<String> lines = SwiftParseUtils.getLines(value);
        if (!lines.isEmpty()) {
            this.setComponent1(SwiftParseUtils.getTokenFirst(lines.get(0), ":", "//"));
            this.setComponent2(SwiftParseUtils.getTokenSecondLast(lines.get(0), "//"));
        }
        SwiftParseUtils.setComponentsFromLines(this, 3, null, 1, lines);
    }

    @Override
    public String getValue() {
        StringBuilder result = new StringBuilder();
        result.append(":");
        this.append(result, 1);
        result.append("//");
        this.append(result, 2);
        this.appendInLines(result, 3, 5);
        return result.toString();
    }

    @Override
    public String getValueDisplay(int component, Locale locale) {
        if (component < 1 || component > 5) {
            throw new IllegalArgumentException("invalid component number " + component + " for field 70C");
        }
        if (component == 1) {
            return this.getComponent(1);
        }
        if (component == 2) {
            return this.getComponent(2);
        }
        if (component == 3) {
            return this.getComponent(3);
        }
        if (component == 4) {
            return this.getComponent(4);
        }
        if (component == 5) {
            return this.getComponent(5);
        }
        return null;
    }

    @Override
    public final String componentsPattern() {
        return COMPONENTS_PATTERN;
    }

    @Override
    public final String parserPattern() {
        return PARSER_PATTERN;
    }

    @Override
    public final String validatorPattern() {
        return ":4!c//35x[$35x]0-3";
    }

    @Override
    public boolean isOptional(int component) {
        if (component == 3) {
            return true;
        }
        if (component == 4) {
            return true;
        }
        return component == 5;
    }

    @Override
    public boolean isGeneric() {
        return true;
    }

    @Override
    public int componentsSize() {
        return 5;
    }

    @Override
    protected List<String> getComponentLabels() {
        ArrayList<String> result = new ArrayList<String>();
        result.add("Qualifier");
        result.add("Narrative");
        result.add("Narrative 2");
        result.add("Narrative 3");
        result.add("Narrative 4");
        return result;
    }

    @Override
    protected Map<Integer, String> getComponentMap() {
        HashMap<Integer, String> result = new HashMap<Integer, String>();
        result.put(1, "qualifier");
        result.put(2, "narrative");
        result.put(3, "narrative2");
        result.put(4, "narrative3");
        result.put(5, "narrative4");
        return result;
    }

    public String getComponent1() {
        return this.getComponent(1);
    }

    public String getQualifier() {
        return this.getComponent(1);
    }

    public String getComponent2() {
        return this.getComponent(2);
    }

    public String getNarrativeLine1() {
        return this.getComponent(2);
    }

    public String getNarrativeLine2() {
        return this.getComponent(3);
    }

    public String getNarrativeLine3() {
        return this.getComponent(4);
    }

    public String getNarrativeLine4() {
        return this.getComponent(5);
    }

    public String getNarrative() {
        return this.getNarrative(null);
    }

    public String getNarrative(CharSequence deli) {
        StringBuilder result = new StringBuilder();
        for (int i = 2; i < 6; ++i) {
            if (this.getComponent(i) == null) continue;
            if (deli != null && result.length() > 0) {
                result.append(deli);
            }
            result.append(this.getComponent(i));
        }
        return result.toString();
    }

    public String getComponent3() {
        return this.getComponent(3);
    }

    public String getComponent4() {
        return this.getComponent(4);
    }

    public String getComponent5() {
        return this.getComponent(5);
    }

    public Field70C setComponent1(String component1) {
        this.setComponent(1, component1);
        return this;
    }

    public Field70C setQualifier(String component1) {
        this.setComponent(1, component1);
        return this;
    }

    public Field70C setComponent2(String component2) {
        this.setComponent(2, component2);
        return this;
    }

    public Field70C setNarrativeLine1(String component2) {
        this.setComponent(2, component2);
        return this;
    }

    public Field70C setNarrativeLine2(String component3) {
        this.setComponent(3, component3);
        return this;
    }

    public Field70C setNarrativeLine3(String component4) {
        this.setComponent(4, component4);
        return this;
    }

    public Field70C setNarrativeLine4(String component5) {
        this.setComponent(5, component5);
        return this;
    }

    public Field70C setNarrative(String value) {
        List<String> lines = SwiftParseUtils.getLines(value);
        SwiftParseUtils.setComponentsFromLines(this, 2, 4, 0, lines);
        return this;
    }

    public Field70C setComponent3(String component3) {
        this.setComponent(3, component3);
        return this;
    }

    public Field70C setComponent4(String component4) {
        this.setComponent(4, component4);
        return this;
    }

    public Field70C setComponent5(String component5) {
        this.setComponent(5, component5);
        return this;
    }

    @Override
    public String getDSS() {
        return null;
    }

    @Override
    public boolean isDSSPresent() {
        return this.getDSS() != null;
    }

    @Override
    public String getConditionalQualifier() {
        return this.getComponent(CONDITIONAL_QUALIFIER);
    }

    @Override
    public String getName() {
        return "70C";
    }

    public static Field70C get(SwiftTagListBlock block) {
        if (block == null || block.isEmpty()) {
            return null;
        }
        Tag t = block.getTagByName("70C");
        if (t == null) {
            return null;
        }
        return new Field70C(t);
    }

    public static Field70C get(SwiftMessage msg) {
        if (msg == null || msg.getBlock4() == null || msg.getBlock4().isEmpty()) {
            return null;
        }
        return Field70C.get(msg.getBlock4());
    }

    public static List<Field70C> getAll(SwiftMessage msg) {
        if (msg == null || msg.getBlock4() == null || msg.getBlock4().isEmpty()) {
            return Collections.emptyList();
        }
        return Field70C.getAll(msg.getBlock4());
    }

    public static List<Field70C> getAll(SwiftTagListBlock block) {
        if (block == null || block.isEmpty()) {
            return Collections.emptyList();
        }
        Tag[] arr = block.getTagsByName("70C");
        if (arr != null && arr.length > 0) {
            ArrayList<Field70C> result = new ArrayList<Field70C>(arr.length);
            for (Tag f : arr) {
                result.add(new Field70C(f));
            }
            return result;
        }
        return Collections.emptyList();
    }

    @Override
    public String getLine(int line) {
        return this.getLine(line, 0);
    }

    @Override
    public String getLine(int line, int offset) {
        Field70C cp = Field70C.newInstance(this);
        return this.getLine(cp, line, null, offset);
    }

    @Override
    public List<String> getLines() {
        return SwiftParseUtils.getLines(this.getValue());
    }

    @Override
    public List<String> getLines(int offset) {
        Field70C cp = Field70C.newInstance(this);
        return SwiftParseUtils.getLines(this.getLine(cp, null, null, offset));
    }

    @Override
    public List<String> getLinesBetween(int start, int end) {
        return this.getLinesBetween(start, end, 0);
    }

    @Override
    public List<String> getLinesBetween(int start, int end, int offset) {
        Field70C cp = Field70C.newInstance(this);
        return SwiftParseUtils.getLines(this.getLine(cp, start, end, offset));
    }

    public static Field70C fromJson(String json) {
        Field70C field = new Field70C();
        JsonParser parser = new JsonParser();
        JsonObject jsonObject = (JsonObject)parser.parse(json);
        if (jsonObject.get("qualifier") != null) {
            field.setComponent1(jsonObject.get("qualifier").getAsString());
        }
        if (jsonObject.get("narrative") != null) {
            field.setComponent2(jsonObject.get("narrative").getAsString());
        }
        if (jsonObject.get("narrative2") != null) {
            field.setComponent3(jsonObject.get("narrative2").getAsString());
        }
        if (jsonObject.get("narrative3") != null) {
            field.setComponent4(jsonObject.get("narrative3").getAsString());
        }
        if (jsonObject.get("narrative4") != null) {
            field.setComponent5(jsonObject.get("narrative4").getAsString());
        }
        return field;
    }
}

