/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.field;

import com.prowidesoftware.swift.model.field.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public abstract class OptionJPartyField
extends Field {
    public static final String PARSER_PATTERN = "S";
    public static final String COMPONENTS_PATTERN = "S";
    public static final Integer PARTY_IDENTIFICATION = 1;

    public OptionJPartyField() {
        super(1);
    }

    public OptionJPartyField(String value) {
        super(value);
    }

    @Override
    public void parse(String value) {
        this.init(1);
        this.setComponent(1, value);
    }

    @Override
    public String getValue() {
        StringBuilder result = new StringBuilder();
        this.append(result, 1);
        return result.toString();
    }

    @Override
    public String getValueDisplay(int component, Locale locale) {
        if (component < 1 || component > 1) {
            throw new IllegalArgumentException("invalid component number " + component + " for field " + this.getName());
        }
        return this.getComponent(component);
    }

    @Override
    public final String componentsPattern() {
        return "S";
    }

    @Override
    public final String parserPattern() {
        return "S";
    }

    @Override
    public abstract String validatorPattern();

    @Override
    public boolean isOptional(int component) {
        return false;
    }

    @Override
    public boolean isGeneric() {
        return false;
    }

    @Override
    public int componentsSize() {
        return 1;
    }

    @Override
    protected List<String> getComponentLabels() {
        ArrayList<String> result = new ArrayList<String>();
        result.add("Party Identification");
        return result;
    }

    @Override
    protected Map<Integer, String> getComponentMap() {
        HashMap<Integer, String> result = new HashMap<Integer, String>();
        result.put(1, "partyIdentification");
        return result;
    }

    @Override
    public abstract String getName();

    public String getComponent1() {
        return this.getComponent(1);
    }

    public String getPartyIdentification() {
        return this.getComponent(1);
    }

    public String getValueByCodeword(Codeword codeword) {
        if (codeword == Codeword.NETS || codeword == Codeword.SSIS) {
            return null;
        }
        String join = StringUtils.replace((String)StringUtils.replace((String)this.getComponent1(), (String)"\r", (String)""), (String)"\n", (String)"");
        String[] tokens = StringUtils.split((String)join, (String)"/");
        for (int i = 0; i < tokens.length; ++i) {
            String code = tokens[i];
            if (StringUtils.equals((CharSequence)code, (CharSequence)Codeword.NETS.name()) || StringUtils.equals((CharSequence)code, (CharSequence)Codeword.SSIS.name()) || ++i >= tokens.length || !StringUtils.equals((CharSequence)code, (CharSequence)codeword.name())) continue;
            return tokens[i];
        }
        return null;
    }

    public static enum Codeword {
        ABIC,
        NAME,
        ACCT,
        ADD1,
        ADD2,
        CITY,
        USFW,
        USCH,
        GBSC,
        CLRC,
        NETS,
        SSIS,
        LEIC,
        TXID,
        NOSI,
        SVBY;

    }
}

