/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.mt.mt1xx;

import com.prowidesoftware.swift.model.MtSwiftMessage;
import com.prowidesoftware.swift.model.SwiftMessage;
import com.prowidesoftware.swift.model.SwiftTagListBlock;
import com.prowidesoftware.swift.model.Tag;
import com.prowidesoftware.swift.model.field.Field;
import com.prowidesoftware.swift.model.field.Field20;
import com.prowidesoftware.swift.model.field.Field21;
import com.prowidesoftware.swift.model.field.Field30;
import com.prowidesoftware.swift.model.field.Field32A;
import com.prowidesoftware.swift.model.field.Field32B;
import com.prowidesoftware.swift.model.field.Field52A;
import com.prowidesoftware.swift.model.field.Field52B;
import com.prowidesoftware.swift.model.field.Field52D;
import com.prowidesoftware.swift.model.field.Field59;
import com.prowidesoftware.swift.model.field.Field76;
import com.prowidesoftware.swift.model.mt.AbstractMT;
import com.prowidesoftware.swift.utils.Lib;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.logging.Logger;
import org.apache.commons.lang3.StringUtils;

public class MT112
extends AbstractMT
implements Serializable {
    public static final int SRU = 2023;
    private static final long serialVersionUID = 1L;
    private static final Logger log = Logger.getLogger(MT112.class.getName());
    public static final String NAME = "112";

    public MT112(SwiftMessage m) {
        super(m);
        this.sanityCheck(m);
    }

    public MT112(MtSwiftMessage m) {
        this(m.message());
    }

    public static MT112 parse(MtSwiftMessage m) {
        if (m == null) {
            return null;
        }
        return new MT112(m);
    }

    public MT112() {
        this("TESTARZZ", "TESTARZZ");
    }

    public MT112(String sender, String receiver) {
        super(112, sender, receiver);
    }

    public MT112(String fin) {
        SwiftMessage parsed;
        if (fin != null && (parsed = MT112.read(fin)) != null) {
            this.m = parsed;
            this.sanityCheck(parsed);
        }
    }

    private void sanityCheck(SwiftMessage param) {
        if (param.isServiceMessage()) {
            log.warning("Creating an MT112 object from FIN content with a Service Message. Check if the MT112 you are intended to read is prepended with and ACK.");
        } else if (!StringUtils.equals((CharSequence)param.getType(), (CharSequence)NAME)) {
            log.warning("Creating an MT112 object from FIN content with message type " + param.getType());
        }
    }

    public static MT112 parse(String fin) {
        if (fin == null) {
            return null;
        }
        return new MT112(fin);
    }

    public MT112(InputStream stream) throws IOException {
        this(Lib.readStream(stream));
    }

    public static MT112 parse(InputStream stream) throws IOException {
        if (stream == null) {
            return null;
        }
        return new MT112(stream);
    }

    public MT112(File file) throws IOException {
        this(Lib.readFile(file));
    }

    public static MT112 parse(File file) throws IOException {
        if (file == null) {
            return null;
        }
        return new MT112(file);
    }

    @Override
    public String getMessageType() {
        return NAME;
    }

    @Override
    public MT112 append(SwiftTagListBlock block) {
        super.append(block);
        return this;
    }

    @Override
    public MT112 append(Tag ... tags) {
        super.append(tags);
        return this;
    }

    @Override
    public MT112 append(Field ... fields) {
        super.append(fields);
        return this;
    }

    public static MT112 fromJson(String json) {
        return (MT112)AbstractMT.fromJson(json);
    }

    public Field20 getField20() {
        Tag t = this.tag("20");
        if (t != null) {
            return new Field20(t.getValue());
        }
        return null;
    }

    public Field21 getField21() {
        Tag t = this.tag("21");
        if (t != null) {
            return new Field21(t.getValue());
        }
        return null;
    }

    public Field30 getField30() {
        Tag t = this.tag("30");
        if (t != null) {
            return new Field30(t.getValue());
        }
        return null;
    }

    public Field32A getField32A() {
        Tag t = this.tag("32A");
        if (t != null) {
            return new Field32A(t.getValue());
        }
        return null;
    }

    public Field32B getField32B() {
        Tag t = this.tag("32B");
        if (t != null) {
            return new Field32B(t.getValue());
        }
        return null;
    }

    public Field52A getField52A() {
        Tag t = this.tag("52A");
        if (t != null) {
            return new Field52A(t.getValue());
        }
        return null;
    }

    public Field52B getField52B() {
        Tag t = this.tag("52B");
        if (t != null) {
            return new Field52B(t.getValue());
        }
        return null;
    }

    public Field52D getField52D() {
        Tag t = this.tag("52D");
        if (t != null) {
            return new Field52D(t.getValue());
        }
        return null;
    }

    public Field59 getField59() {
        Tag t = this.tag("59");
        if (t != null) {
            return new Field59(t.getValue());
        }
        return null;
    }

    public Field76 getField76() {
        Tag t = this.tag("76");
        if (t != null) {
            return new Field76(t.getValue());
        }
        return null;
    }
}

